<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 Ext_JCUser_Register 
 *
 * @access public
 */
class Ext_JCUser_Modify extends W3B_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCUser_Modify(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
		
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService) ;
		
		$aIdMgr = $aService->GetIdManager() ;
		$aId = $aIdMgr->QueryIdentity(Ext_JCUser_Identity::ID_CLASS) ;
		if( !$aId or !$aId->IsLogined() )
		{
			$aFrame->DenyAccess() ;
			return ;
		}

		// 创建文档
		$aUsrModel = $aId->GetModel() ;
		if( JCAT_Global::IsKindOf($aUsrModel,'Ext_JCUser_Identity') )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'以外的身份类; 期待的类型为：Ext_JCUser_Identity，身份管理器中的类型为：%'
				, 'Ext_JCUser', null, get_class($aUsrModel)
			)) ;
		}
		
		// 重新设置数据库
		$aUsrModel->GetORM()->SetDB(W3B_Platform::GetDefaultDB()) ;
		
		// 视图: Ext_JCUser_ViewFormBaseInfo
		$aUsrBaseInfoView = new Ext_JCUser_ViewFormMoreInfo($this) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aUsrBaseInfoView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','Ext_JCUser_ViewFormBaseInfo')) ;
		$aUsrBaseInfoView->SetModel($aUsrModel) ;

		$aUsrBaseInfoView->ExchangeData(JCAT_IViewForm::DOC_TO_UICTRL) ;
		$aUsrBaseInfoView->SetUICtrlExchangeData('Birthday',date('Y-m-d',$aUsrModel->Get('sBirthday'))) ;

		
		// 提交表单视图 Ext_JCUser_ViewFormBaseInfo
		if( $aUsrBaseInfoView->IsSubmitingForm() ) 
		{do{
			
			$aUsrBaseInfoView->SetDataFromSubmited() ;

			// 用户输入校验
			if( !$aUsrBaseInfoView->VerifyData() )
			{
				break ;
			}
			
			// 数据交换
			$aUsrBaseInfoView->ExchangeData() ;
			
			$sBirthday = $aUsrModel->Get('nBirthday') ;
			$nBirthday = JCAT_String::DateToTimeStamp($sBirthday) ;
			$aUsrModel->Set('nBirthday',$nBirthday) ;
			
			// 保存
			if( $aUsrModel->Save() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('用户资料保存成功','Ext_JCUser',null),MSGMVC_OK) ;
			}
			
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('用户资料保存失败','Ext_JCUser',null),MSGMVC_BAD) ;
			}
			
		}while(0) ;}

		
		// 框架
		$aFrame->RenderFrame($aUsrBaseInfoView) ;
	}

}

?>