<?php 
/**
 * ... ...
 * ... ...
 *
 */ 



/**
 * 控制器类 Ext_JCUser_List 
 *
 * @access public
 */
class Ext_JCUser_ModifyPurview 
	extends W3B_Controller 
{
	const MODEL_USER = 'MODEL_USER' ;
	const VIEW_PURVIEWS = 'VIEW_PURVIEWS' ;
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCUser_ModifyPurview(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_BAD) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_DEBUG) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 


		$aModel = new Ext_JCUser_Model(true) ;
		$this->AddModel($aModel,self::MODEL_USER) ;

		// 创建并加载视图
		$aView = new JCAT_ViewHtmlForm('template.Ext_JCUser_ViewModifyPurview.html',$this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_PURVIEWS) ;

		// 		
		$aRequest = $this->GetRequest() ;		
		if( !$aRequest->GetParam('type') )
		{
			$aRequest->SetParam('type',Ext_JCCMS::CATEGORY_TYPE_ARTICLE) ;
			$aView->SetViewVar('sItemType',JCAT_Language::SentenceEx('用户','Ext_JCCMS',null)) ;
		}

		$this->InitializeFrameMenuPath() ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('用户管理','Ext_JCUser',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aRequest = $this->GetRequest() ;
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($aRequest);
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}

		$aView = $this->GetView(self::VIEW_PURVIEWS) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aView,'JCAT_IViewHtml');
		$aView->ShowForm(false) ;
		
		do {
		
			// 载入用户
			// -----------------------------------
			if( !$nUserId=$aRequest->GetParam('nUserId') or !$nUserId=intval($nUserId) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nUserId 或参数 nUserId 无效','Ext_JCUser',null),MSGMVC_BAD) ;
				break ;
			}
			
			$aModel = $aView->GetModel() ;
			$aModel->FindBy('nUserId',$nUserId) ;
			
			if(!$aModel->Load())
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的用户不存在（nUserId:%d）','Ext_JCUser',null,$nUserId),MSGMVC_BAD) ;
				break ;
			}
			
			// 
			$aService = $this->GetService() ;
			$aExtUser = $aService->GetExtensionManager()->GetLoadedExtension('Ext_JCUser') ;
			$aView->SetViewVar('aExtUser',$aExtUser) ;
			$aView->SetViewVar('nServiceId',$this->GetService()->GetServiceId()) ;
			
			// 设置用户权限
			// -----------------------------------
			$this->SetPurviews($aRequest,$aExtUser) ;
			
			
			$aView->ShowForm(true) ;
			
		} while(0) ;
		
		
		$aFrame->RenderFrame($aView) ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function SetPurviews(JCAT_Request $aRequest,W3B_Extension $aExtUser)
	{
		if(!$aRequest->GetParam('bSubmit'))
		{
			return ;
		}
		$nServiceId = $this->GetService()->GetServiceId() ;

		// 注册权限
		$arrRegisteredPurview = array() ;
		$aGrpIterator = $aExtUser->CreatePurviewGroupNameIter() ;
		for ( $aGrpIterator->First(); !$aGrpIterator->IsDone(); $aGrpIterator->Next() )
		{
			$sGrpName = $aGrpIterator->Current() ;
			
			$aNameIterator = $aExtUser->CreatePurviewNameIter($sGrpName) ;
			for ( $aNameIterator->First(); !$aNameIterator->IsDone(); $aNameIterator->Next() )
			{
				$sName = $aNameIterator->Current() ;
				$sPurviewDomain = $aExtUser->GetPurviewDomain($sGrpName,$sName) ;
				$sPurviewBit = $aExtUser->GetPurviewBit($sGrpName,$sName) ;

				$arrRegisteredPurview["{$nServiceId}::{$sPurviewDomain}::{$sPurviewBit}"] = false ;
			}
		}

		// 变更后的权限
		$arrPurviews = $aRequest->GetParam('arrPurviews') ; 
		if( is_array($arrPurviews) )
		{
			foreach ($arrPurviews as $sPurviewKey)
			{
				$arrRegisteredPurview["{$nServiceId}::{$sPurviewKey}"] = true ;
			}
		}

		// 现有权限
		$arrExistPurviews = array() ;
		$aModel = $this->GetModel(self::MODEL_USER) ;
		$aAllPurviews = $aModel->GetModel(Ext_JCUser_Model::PROP_PURVIEWS) ;
		
		$aIterator = $aAllPurviews->CreateModelIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aPurview = $aIterator->Current() ;
			
			$sUserPurviewDomain = $aPurview->Get(JCAT_DBIdentity::PURVIEW_DOMAIN) ;
			$sUserPurviewBit = $aPurview->Get(JCAT_DBIdentity::PURVIEW_BIT) ;
			$nUserPurviewServiceId = $aPurview->Get(Ext_JCUser_Model::PROP_SERVICEID) ;
			$sPurviewKey = "{$nUserPurviewServiceId}::{$sUserPurviewDomain}::{$sUserPurviewBit}" ;
			$arrExistPurviews[$sPurviewKey] = true ;

			// 移除权限
			if( isset($arrRegisteredPurview[$sPurviewKey]) and !$arrRegisteredPurview[$sPurviewKey] )
			{
				try{
					$aModel->RemovePurview(intval($sUserPurviewBit),$sUserPurviewDomain,$nServiceId) ;
					new JCAT_Message(JCAT_Language::SentenceEx('移除了权限 %s:%s','Ext_JCUser',null,$sUserPurviewDomain,$sUserPurviewBit),MSGMVC_OK) ;
				}catch(JCAT_Exception $e){
					new JCAT_Message(
						JCAT_Language::SentenceEx('在移除权限时遇到错误:%s','Ext_JCUser',null,$e->GetMsg()),MSGMVC_BAD
					) ;
				}
			}
		}

		// 添加权限
		$arrNewPurviews = array_diff_key($arrRegisteredPurview,$arrExistPurviews) ;
		if(is_array($arrNewPurviews))
		{
			foreach ($arrNewPurviews as $sNewPurviewKey=>$bool)
			{
				if(!$bool)
				{
					continue ;
				}

				list(,$sNewPVDomain,$sNewPVBit) = explode('::',$sNewPurviewKey) ; 
				
				try{
					if( $aModel->AddPurview($sNewPVBit,$sNewPVDomain,$nServiceId) )
					{
						new JCAT_Message(JCAT_Language::SentenceEx('添加了权限 %s:%s','Ext_JCUser',null,$sNewPVDomain,$sNewPVBit),MSGMVC_OK) ;
					}
					else 
					{
						new JCAT_Message(
							JCAT_Language::SentenceEx('在添加权限时遇到错误:%s','Ext_JCUser',null,$aModel->GetORM()->GetDB()->GetConnect()->GetError()),MSGMVC_BAD
						) ;
					}
				}catch(JCAT_Exception $e){
					new JCAT_Message(
						JCAT_Language::SentenceEx('在添加权限时遇到错误:%s','Ext_JCUser',null,$e->GetMsg()),MSGMVC_BAD
					) ;
				}
			}
		}
		// print_r($arrNewPurviews) ;
	}

}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFMlQzFuJURCRiUxNCVCQyUxNyVFOCUzRjglRkMlMDAlOEIlMTQlQTUlRDQlQTUlODMlMDAlMTJJJTI5JURBZCUyOSUyRiVDOSVBNSUyMyU1RCUwQ1olREFIJTE0VyVBMislRDIlOTUlMjhDJUQ3JTlDeiVFOTklRTglMjElNDAlODElMUVzLiU4MiVFNGslRTIlQzIlOUYlRDFZJTJBJUIyJUUzJTAyJThEJTBC
YkFyJUY3JUJEJTk5eSVGMyVERSVDNlYlREQlQkElQ0UlQUQlODYlQTU5cSUxMWslQTclQjElRDVUJUZGJTA2NiVFQ2xRJUFDMiUyOSVDNSVFQSUyQy4lQTYlREElMjl2JUY1JUE2JUE1JUQ1JUE2JUQ5JTVDJUQ0YiUyOUQlRURsJTk1JUNEJUM0JUE4JUE4JTExYSVDN0UlRUQlRENsJTlGJUM5JUI4eCU5MyVBRCVFNjV3
UyU4OEUlOUVkJTBCJUY1dUFsJTlFJThCVSVDRDglRDYlRDVzJTE0JUNCJUU1NCVBRSVEOTIlQ0VzJTkxJUQ3RiVFQSU3RCU3QyUxRnYlRjElMkElQzklOEIlRTMlRTV0WTElM0UlRDAlRTElQzVzUSVFREIlQzYlQkYlMTIlRDQlRjZPJTk2RiVGM0lYLiVDNSVENyUzQSUxMkslQzdHVSVFMCU4OSVBNSU4RCVBNiU4OSUx
QyVBRiVDNEIlMUQlRUElRDYlRjVOJTlEJUU2JUQ2UyUyNCUwNSU1RCUxQSVEOSVEQSUyOXYlOENHJUUzJTdGJTNFJUM0XyVGNF9WJTI5JUY1R1MlMEMlRkQuJUE3JUREciVBQSUyNCVGMyVGMSVBNCVGQSU1RCU5MiVFMyVCNnklQjdKayUzQyU5QSUwNiUyQUQlRUUlRjYlM0ElRjMlQzklRDklMkElMjklQzRKJTg1JTk4
JTA3JTNCJTFBJURGJUM5JUJGJTg0JTAxJUNBJTA0JUQwJTFCJTk2JUY2JTIyJUE0JUFGJThFbiVGRiU3QyU3QiVGMyVFRSVCM3YlQUElMEElQ0QlQUQlQkFpaSVDNG4lODUlMTdUJUU0eSUzQyUxMSUyQSUwNCUxQyU4QiU4QSVFNCVBQiU3RiVERiUyNyVEMCUwRiUwNCU0MCVFQSUxNiVFOSVEMSVDRCU4NyVCRm4lM0Yl
RkMlRkUlRjclRkIlQjd3JTE0JTI3JTBGJTI5JTEwJUU0JTI0JUIxJUNDJTI2JURGJUYyJUQ0JUZGNyUwRiU3QyVCOCVGOSVFRCVEMyU5NyU4RiU3RiVEQyVCRSVGRiVGNSU0MGElRUElMEYlMjklRUNsJTNFJThGJTE3YyU5OSUyQyVDNCUzRCVDOW5vJTAyJTI2JTBDJTNFJUIyJTJCcSVCNSUxRiUzREszcFglMTElREIl
REYlMTAlMUIlMDclN0JNJUE1JTBBJUYzWSU4RCVCNSVDQSVBODclRjdkJUU4ZCVGRlIlNUQlMTc1JUNGMSVBOFZONlIlMDElMTglRjElQzVhJUIwJTAxJThGJUI4JTdCJUUwJUVBdCU1QyVEREwlQ0MlRjdTJTE0JUYzJUVDJUQ5JUY1NSUxMiVBRiVFNmJRVFclQzglRkFPJUYwJUREJUVFJUY5JUYzJTFGJTdGJTEwdiVF
NCVCMiU4MCU5QiVCRSVDRCUxQiU3RSUxMjklRjQlM0MlOTNsSyVENyUyNHQlRDclQkUlMUR1JUZEJTk0SyVDQSUwNyVEMiU5QiVCNSVBNCVFRiVBNCVCMiVFRiVCQSVCMiUxRlIlMkMlMjYlRkQlMTklOTclMkNMJTFCJTI0JUVDJTE5JTI0JTlDNEklRDhqJTEyTjclMjRMdSVDMiU3QnpURjY1JTA3JTg4JTFEJTBGWCUx
MCVEOSU1RSVDMiUxQiVBQyU4QyVEQSU1RSVDMDclRDQlQTUlQzBrSSU5NiUwRU0lM0YlRTBlJTFGJUU3JThBJUNGJTBCJTA3JTkyJUVBJTNESSU1RCVFRiU5N2ElODk4JTg3JTAwJURGayUwMyVCNyUwMSU4QyUwRSVGMiU1RGpHbVolMjIlQzclQzZ5JTg3JTAxJUMzJTdCQ0IlQjYlREUlRjMlMTIlRDclOTMlMjclNUIl
MTJOJTVEJUMyJUQ5JTg2cCVBRSVCRSUxRCVFOCVBQiVFRiVDRiVBOUElRjglQTAlRUVvJTI3JUE4cyUxQSVBOCUzQSVBMyslRUElRjZfJTJGJTk3JTg4JUVCJTkwUHYlQjElREElMjQlRUN0JTA4d0slNjAlMjglREM1JUVBJTAxJTE2JUIxJUNGJTAzJURFJTAwdyUxMyUxQSVBMCU5N28lN0MlMTc4JTIxJUY0JUNFJTk0
JTJGJTNEeCUxMiVFNSU5NyVEMCVFOCVCRCU5MEMlOEUlRDglN0UlQzAlMEQlM0YlQzAlM0ZqJUY3JUNBJUE4JUNCJUNFJTdCJTkycSU3Rkl4JUU0JUMyNyVFMCVGQiU1RGglODJvJTBDa2glRTMlMUZaU3glRTglRTElREQlRUUlMDglOUIlOTclQ0ElQUYlQkUlRjIlQUMlQzIlOEIlMUMlRjRrJUUzQSUwMyVGNktPJUY5
YU4lRDAlMTclRThEbUolMTclRjYlRDclMUVqJUEyJTk1JUU3JUE4JTBEJTdFJTgxJUJGRCVERSVENk8lRjglMDYlMUUlM0ElRjAlREElRjElREQlQjQlRjIlOUElQTUlMDMlQzlmJUU4JTg3JUNCJUE0JUE3JUMzJUNGUCVGNSVEQSU5NSUzRSVGNlUlRkYlM0QlRUVtJUY2JTFFTlUlQ0RNaCVFOCVBQVklRTklQkYlRTYl
ODglRUIlOTQlN0UlQzklRDclQ0ElMEIlOTYlODBPJUEyJTdGJUFBJUI3YVolQkQlQTklQUUlN0MlMTklMDElMDczJUUzeCUyRiVFMSUyOSVGQTAlODYlQ0ZuJTg5JUJFJUFGJUQxJUMzLUMlMkZZJUMyJUQ3VCVDRCUwQmIlRDlsJUQ4JTE5QSVBMyVGMiUwQzUlMUIlQUElRTclODhpJUMyRyU4NyVDRSUxNCU4RSU5QSVC
RCUxNiVGMCVBMXUlODYlQzUlQTElOUJDSyVDOCU5RiVBOCVBQiVCOSVGQiUwN1QlNUUzVg!!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>