<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 Ext_JCUser_Register 
 *
 * @access public
 */
class Ext_JCUser_Register extends W3B_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCUser_Register(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,self::MSG_SUC) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,self::MSG_FAIL) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
		
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		// 视图: Ext_JCUser_ViewFormBaseInfo
		$aUsrBaseInfoView = new Ext_JCUser_ViewFormBaseInfo($this) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aUsrBaseInfoView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','Ext_JCUser_ViewFormBaseInfo')) ;
		
		$aUsrModel = new Ext_JCUser_Model(false) ;
		$aUsrBaseInfoView->SetModel($aUsrModel) ;

		// 提交表单视图 Ext_JCUser_ViewFormBaseInfo
		if( $aUsrBaseInfoView->IsSubmitingForm() ) 
		{do{
			$aUsrBaseInfoView->SetDataFromSubmited() ;

			// 用户输入校验
			if( !$aUsrBaseInfoView->VerifyData() )
			{
				break ;
			}
			
			// 数据交换
			$aUsrBaseInfoView->ExchangeData() ;
			
			$nBirthday = JCAT_String::DateToTimeStamp($aUsrModel->Get('nBirthday')) ;
			$aUsrModel->Set('nBirthday',$nBirthday) ;
			
			// 创建用户
			$aUsrBaseInfoView->ShowForm( !self::CreateNewUserByDocument($aUsrModel) ) ;
			
		}while(0) ;}


		// 创建框架 控制器
		$sFrameClass = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$this->GetService()) ;
		$sFrameClass->RenderFrame($aUsrBaseInfoView);
	}

	/**
	 * 创建一个用户账号
	 *
	 * @access	protected
	 * @param	$aUsrDocument		Ext_JCUser_Document		用户文档
	 * @static
	 * @return	bool
	 */
	static protected function CreateNewUserByDocument( Ext_JCUser_Model $aUsrDocument )
	{
		// 检查重复 用户名
		if( Ext_JCUser_Model::IsUserExists($aUsrDocument->Get('sUserName')))
		{
			new JCAT_Message(JCAT_Language::SentenceEx('对不起，用户名“%s”已经被占用;你不能使用这个用户名。','Ext_JCUser',null,$aUsrDocument->Get('sUserName')),self::MSG_FAIL) ;
			return false ;
		}
				
		// 检查重复 Email
		if( Ext_JCUser_Model::IsEmailExists($aUsrDocument->Get('sEmail')))
		{
			new JCAT_Message(JCAT_Language::SentenceEx('对不起，Email“%s”已经被占用;你不能使用这个Email。','Ext_JCUser',null,$aUsrDocument->Get('sEmail')),self::MSG_FAIL) ;
			return false ;
		}
		
		// 账号 创建时间
		$aUsrDocument->Set('nCreateTime',time()) ;
		
		// 密码加密
		$sPassword = $aUsrDocument->Get('sPassword') ;
		$sPassword = md5($sPassword) ;
		$aUsrDocument->Set('sPassword',$sPassword) ;
		
		// 创建
		if( $aUsrDocument->Create() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('创建用户 %s 成功。','Ext_JCUser',null,$aUsrDocument->Get('sUserName')),self::MSG_SUC) ;
			return true ;			
		}

		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('创建用户 %s 失败。','Ext_JCUser',null,$aUsrDocument->Get('sUserName')),self::MSG_FAIL) ;	
			return false ;		
		}
	}
	
	/**
	 * 创建一个用户账号
	 *
	 * @access	public
	 * @param	$sUsername		string		用户名
	 * @param	$sPassword		string		密码
	 * @param	$sEmail			string		电邮
	 * @static
	 * @return	Ext_JCUser_Document
	 */
	static public function CreateNewUser( $sUsername, $sPassword, $sEmail )
	{
		$aUsrDocument = new Ext_JCUser_Model() ;
		$aUsrDocument->Set('Ext_JCUser.sUserName',$sUsername) ;
		$aUsrDocument->Set('Ext_JCUser.sPassword',$sPassword) ;
		$aUsrDocument->Set('Ext_JCUser.sEmail',$sEmail) ;
		
		return self::CreateNewUserByDocument($aUsrDocument)?
					$aUsrDocument: null ;
	}

	const MSG_SUC = 'MSG_SUC' ;
	
	const MSG_FAIL = 'MSG_FAIL' ;
}

?>