<?php

class Ext_JCUser_Retrieve extends W3B_Controller
		implements JCAT_IHTTPPublicController
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCUser_Retrieve(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
		
	}
	
	/**
	 * @see JCAT_IController::MainRun()
	 *
	 */
	public function MainRun ()
	{
		$aService = $this->GetService() ;
		
		// 视图: Ext_JCUser_ViewFormBaseInfo
		$aLoginView = new JCAT_ViewHtmlForm('template.Ext_JCUser_RetrieveView.html',$this) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aLoginView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','Ext_JCUser_Login')) ;
		
		// 提交表单视图
		if( $aLoginView->IsSubmitingForm() ) 
		{
			$aRequest = $this->GetRequest() ;
			$sUsername = $aRequest->GetParam('sUsername') ;
			
			$aUserService = new Ext_JCUser_Model() ;
			$aUserPlatfomr = new Ext_JCUser_Model() ;
			$aUserService->FindBy('sUserName',$sUsername) ;
			$aUserPlatfomr->FindBy('sUserName',$sUsername) ;
			$aUserService->FindBy('nServiceId',$this->GetService()->GetServiceId()) ;
			$aUserPlatfomr->FindBy('nServiceId',0) ;
			
			if( $bServiceUser = $aUserService->Load() or $aUserPlatfomr->Load() )
			{
				$aUser = $bServiceUser? $aUserService: $aUserPlatfomr ;
				
				$aUser->Set('sRetrievePwdCode',md5( microtime().rand(0,999999) )) ;
				$aUser->Set('sRetrievePwdTime',time()) ;
				
				$aUser->Save() ;
				
				// 发送邮件
				if( $this->SendMail($aUser) )
				{
					$aLoginView->ShowForm(false) ;
				}
			}
			
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('用户不存在：%s','Ext_JCUser',null,$sUsername),MSGMVC_BAD) ;
			}
			
			$sUsername ;
		}

		// 显示视图
		if( $this->GetParentController() )
		{
			$aLoginView->ShowView() ;
		}
		
		else 
		{	
			// 执行框架 控制器
			$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService,array($this)) ;
			$aFrame->PutinView($aLoginView) ;
			$aFrame->MainRun() ;
		}
	}
	
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$aUser		Ext_JCUser_Model
	 * @return	bool
	 */
	private function SendMail(Ext_JCUser_Model $aUser)
	{
		//
		$aPreference = $this->GetPlatform()->GetPreference() ;
		$aMailer = new PHPMailer() ;
		
		$aMailer->IsSMTP() ;
		$aMailer->SMTPAuth = true ;
		$aMailer->CharSet = 'utf-8' ;
		
		$aMailer->Host = $aPreference->GetItem('/Platform/Resource/SMTP','SMTPServer') ;
		$aMailer->Port = $aPreference->GetItem('/Platform/Resource/SMTP','SMTPPort') ;
		$aMailer->SMTPSecure = $aPreference->GetItem('/Platform/Resource/SMTP','SMTPSecure') ;

		$aMailer->Username   = $aPreference->GetItem('/Platform/Resource/SMTP','SMTPUser') ;
		$aMailer->Password   = $aPreference->GetItem('/Platform/Resource/SMTP','SMTPPassword') ;

		$aMailer->From = $aPreference->GetItem('/Platform/Resource/SMTP','AuthorAddress') ;
		$aMailer->FromName = $aPreference->GetItem('/Platform/Resource/SMTP','AuthorName') ;
		
		$aMailer->AddReplyTo( $aPreference->GetItem('/Platform/Resource/SMTP','Reply') ) ;
		
		$aMailer->Subject = JCAT_Language::SentenceEx('找回您的密码','Ext_JCUser',null) ;
		$aMailer->AddAddress($aUser->Get('sEmail')) ;
		
		// 内容
		$aUI = new JCAT_UIHtml() ;
		$aUI->SetVar('TheRequest',$this->GetRequest()) ;
		$aUI->SetVar('TheModel',$aUser) ;
		$aMailer->AltBody = $aUI->Display('template.Ext_JCUser_RetrieveMailBody.html',JCAT_UIHtml::RETURN_OUTPUT) ;
		$aMailer->Body = $aUI->Display('template.Ext_JCUser_RetrieveMailHtmlBody.html',JCAT_UIHtml::RETURN_OUTPUT) ;
		
		$aMailer->IsHTML( !empty($aMailer->Body) ); // send as HTML
		
		
		// 发送
		if( $aMailer->Send() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('系统已经将一封用于确认您身份的邮件发送到你的信箱中了，请前往您的邮箱完成操作。','Ext_JCUser',null),MSGMVC_OK) ;
			return true ;
		}
		
		else
		{
			new JCAT_Message(JCAT_Language::SentenceEx('系统在发送一封用于确认您身份的邮件时遇到了错误: %s。','Ext_JCUser',null,$aMailer->ErrorInfo),MSGMVC_BAD) ;
			return false ;
		}
		
	}
	
	
}

?>
