<?php

class Ext_JCUser_Retrieve_NewPWD extends W3B_Controller implements JCAT_IHTTPPublicController
{

	const RetrieveExpire = 10 ;
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCUser_Retrieve_NewPWD(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
	}
	
	/**
	 * @see JCAT_IController::MainRun()
	 *
	 */
	public function MainRun ()
	{
		$aService = $this->GetService() ;
		
		// 视图: Ext_JCUser_ViewFormBaseInfo
		$aLoginView = new JCAT_ViewHtmlForm('template.Ext_JCUser_Retrieve_NewPWDView.html',$this) ;
		$aLoginView->ShowForm(false) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aLoginView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','Ext_JCUser_Login')) ;

		$aRequest = $this->GetRequest() ;
		$sUsername = $aRequest->GetParam('sUsername') ;

		do {
			if( !$sUsername )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 sUsername','Ext_JCUser',null),MSGMVC_BAD) ;
				break ;
			}
			
			$aUserService = new Ext_JCUser_Model() ;
			$aUserPlatfomr = new Ext_JCUser_Model() ;
			$aUserService->FindBy('sUserName',$sUsername) ;
			$aUserPlatfomr->FindBy('sUserName',$sUsername) ;
			$aUserService->FindBy('nServiceId',$this->GetService()->GetServiceId()) ;
			$aUserPlatfomr->FindBy('nServiceId',0) ;
			
			if( !$bServiceUser=$aUserService->Load() and !$aUserPlatfomr->Load() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('用户不存在：%s','Ext_JCUser',null,$sUsername),MSGMVC_BAD) ;
				break ;
			}
			
			$aUser = $bServiceUser? $aUserService: $aUserPlatfomr ;
			if( $aUser->Get('sRetrievePwdCode')!=$aRequest->GetParam('code') )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('链接无效','Ext_JCUser',null),MSGMVC_BAD) ;
				break ;
			}
			if( $aUser->Get('sRetrievePwdTime')+Ext_JCUser_Retrieve_NewPWD::RetrieveExpire*60<time() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('链接过期，您必须在 %d 分钟内完成操作。','Ext_JCUser',null,Ext_JCUser_Retrieve_NewPWD::RetrieveExpire),MSGMVC_BAD) ;
				break ;
			}
			
			$aLoginView->ShowForm(true) ;
	
			// 提交表单视图
			if( $aLoginView->IsSubmitingForm() ) 
			{
				$sPassword = $aRequest->GetParam('sPassword') ;
				$sPasswordRepeat = $aRequest->GetParam('sPasswordRepeat') ;
				
				if(!$sPassword)
				{
					new JCAT_Message(JCAT_Language::SentenceEx('请输入密码','Ext_JCUser',null),MSGMVC_BAD) ;
					break ;
				}

				if($sPassword!=$sPasswordRepeat)
				{
					new JCAT_Message(JCAT_Language::SentenceEx('两次密码不一致。','Ext_JCUser',null),MSGMVC_BAD) ;
					break ;
				}
				
				$aUser->Set('sPassword',md5($sPassword)) ;
				$aUser->Set('sRetrievePwdCode','') ;
				$aUser->Set('sRetrievePwdTime',0) ;
				if( $aUser->Save() )
				{
					new JCAT_Message(JCAT_Language::SentenceEx('密码已经修改。','Ext_JCUser',null),MSGMVC_OK) ;
					$aLoginView->ShowForm(false) ;
				}
				else 
				{
					new JCAT_Message(JCAT_Language::SentenceEx('系统在修改密码时遇到了错误。','Ext_JCUser',null),MSGMVC_BAD) ;
				}
				
			}
			
		} while(0) ;
		
		$sUsername ;

		// 显示视图
		if( $this->GetParentController() )
		{
			$aLoginView->ShowView() ;
		}
		
		else 
		{	
			// 执行框架 控制器
			$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService,array($this)) ;
			$aFrame->PutinView($aLoginView) ;
			$aFrame->MainRun() ;
		}
	}
	
	
	
	
}

?>
