<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 视图类 Ext_JCUser_ViewFormBaseInfo 
 *
 * @access public
 */
class Ext_JCUser_ViewFormBaseInfo extends JCAT_ViewHtmlForm
{
	
	/**
	 * 构造函数 
	 *
	 * @access	public
	 * @param	$aParent	JCAT_IViewContainer		视图的父对象(父视图 或 控制器)。注意：视图不应单独存在，必须有一个父对象！ 
	 * @param	$aUI=null	JCAT_IUIHtml			UI 对象 
	 * @return	void
	 */
	public function Ext_JCUser_ViewFormBaseInfo(JCAT_IViewContainer $aParent,JCAT_IUIHtml $aUI=null)
	{
		// 调用父类构造函数 
		$this->JCAT_ViewHtml('template.Ext_JCUser_ViewFormBaseInfo.html',$aParent,'Ext_JCUser_ViewFormBaseInfo',$aUI) ;

		$this->Initialize() ;	
	}
	
	/**
	 * 初始化 视图 
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		// 载入UI控件
		$sCurrentDirectory = dirname(__FILE__).'/' ;
		$this->AddUICtrl(JCAT_Package::ImportInstance($sCurrentDirectory.'Instance.UICtrls/instance.User.php'),'sUserName') ;
		$aPassword = JCAT_Package::ImportInstance($sCurrentDirectory.'Instance.UICtrls/instance.Password.php') ;
		$aPasswordRepeat = JCAT_Package::ImportInstance($sCurrentDirectory.'Instance.UICtrls/instance.PasswordRepeat.php') ;
		$aPasswordRepeat->AddVerifier(new JCAT_UICtrlRepeatVerifier($aPassword)) ;
		$this->AddUICtrl($aPassword,'sPassword') ;
		$this->AddUICtrl($aPasswordRepeat) ;
		$this->AddUICtrl(JCAT_Package::ImportInstance($sCurrentDirectory.'Instance.UICtrls/instance.Email.php'),'sEmail') ;

		// 更多信息 子视图
		$this->AddView( new Ext_JCUser_ViewFormMoreInfo($this) ) ;
	}

	
	public function SetModel( JCAT_IModel $aModel )
	{
		parent::SetModel($aModel) ;
		
		$this->GetView('Ext_JCUser_ViewFormMoreInfo')->SetModel($aModel) ;
	}
}

?>