<?php

class Ext_JCUser_RCUpgrade0_1_0to0_1_1 extends W3B_ExtensionRCUpgrade
{
	const VER_FROM = '0.1.0' ;
	const VER_TO = '0.1.1' ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetExtentionName()
	{
		return 'Ext_JCUser' ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetVersionFrom()
	{
		return JCAT_Version::FromString(self::VER_FROM) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetVersionTo()
	{
		return JCAT_Version::FromString(self::VER_TO) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function MainRun()
	{
		$this->CheckPlatformRCVersion() ;
		
		$aPlatform = $this->GetPlatform() ;
		$aDB = $aPlatform->GetDefaultDB() ;
		if( $aDB->Query("ALTER TABLE `Ext_JCUser` ADD `sRetrievePwdCode` VARCHAR( 32 ) NOT NULL , ADD `sRetrievePwdTime` INT( 10 ) NOT NULL") )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('升级数据表 Ext_JCUser 成功。','Ext_JCUser',null),W3B_IExtensionSetup::MSG_SUCCEED) ;

			$this->UpdatePlatformRCVersion() ;
			return true ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('系统在升级数据表 Ext_JCUser 的时候遇到了错误。','Ext_JCUser',null),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
	}
}

?>
