<?php

class Ext_JCUser_Setup extends W3B_ExtensionDefaultSetup 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function GetResourceDBTables()
	{
		$arrDBTables['Ext_JCUser'] = "CREATE TABLE IF NOT EXISTS `Ext_JCUser` (
  `nUserId` int(11) NOT NULL auto_increment,
  `nServiceId` int(8) NOT NULL default '0',
  `sUserName` varchar(30) NOT NULL default '',
  `sPassword` varchar(40) NOT NULL default '',
  `sEmail` varchar(80) NOT NULL default '',
  `nCreateTime` int(10) unsigned NOT NULL default '0',
  `nLastLoginTime` int(10) unsigned NOT NULL default '0',
  `sLastLoginIP` varchar(15) NOT NULL default '',
  `sActiveIP` varchar(15) NOT NULL default '',
  `nActiveTime` int(10) unsigned NOT NULL default '0',
  `sQQ` varchar(16) NOT NULL default '',
  `sMSN` varchar(40) NOT NULL default '',
  `sHome` varchar(40) NOT NULL default '',
  `sTel` varchar(20) NOT NULL default '',
  `sFax` varchar(20) NOT NULL default '',
  `sMobile` varchar(20) NOT NULL default '',
  `sCompanyName` varchar(60) NOT NULL default '',
  `sLinkman` varchar(30) NOT NULL default '',
  `sAddress` varchar(120) NOT NULL default '',
  `nBirthday` int(8) NOT NULL default '0',
  `nSex` enum('1','2','0') NOT NULL default '0',
  `sFace` varchar(80) NOT NULL default '',
  `sRetrievePwdCode` varchar(32) NOT NULL default '',
  `sRetrievePwdTime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`nUserId`),
  UNIQUE KEY `sUserName` (`sUserName`),
  KEY `sUserName_Index` (`sUserName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;" ;
		
		$arrDBTables['Ext_JCUser_Purview'] = "CREATE TABLE IF NOT EXISTS `Ext_JCUser_Purview` (
  `nPurviewId` int(6) NOT NULL auto_increment,
  `sPurviewName` varchar(120) NOT NULL default '',
  `nPurviewBit` int(10) NOT NULL default '0',
  `sPurviewDomain` varchar(40) NOT NULL default '',
  `sComment` text,
  `sData` text,
  PRIMARY KEY  (`nPurviewId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;" ;
		
		$arrDBTables['Ext_JCUser_PurviewLink'] = "CREATE TABLE IF NOT EXISTS `Ext_JCUser_PurviewLink` (
  `nPurviewLinkId` int(11) NOT NULL auto_increment,
  `nServiceId` int(8) NOT NULL default '0',
  `nPurviewId` int(6) NOT NULL default '0',
  `nUserId` int(11) NOT NULL default '0',
  `nGroupId` int(11) NOT NULL default '0',
  `nSince` int(10) NOT NULL default '0',
  `nExpir` int(10) NOT NULL default '0',
  PRIMARY KEY  (`nPurviewLinkId`),
  UNIQUE KEY `nServiceId` (`nServiceId`,`nPurviewId`,`nUserId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;" ;
		
		
		
		// 升级
		// ALTER TABLE `Ext_JCUser` ADD `sRetrievePwdCode` VARCHAR( 32 ) NOT NULL , ADD `sRetrievePwdTime` INT( 10 ) NOT NULL 
		
		return $arrDBTables ;
	}
	
	/**
	 * 回收平台资源（完全卸载时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Service
	 * @return	void
	 */
	public function ClearServiceResource(W3B_Service $aService) 
	{
		$this->ClearSrvRCBySrvId($aService) ;
	}

}

?>
