JCAT.Class.CheckDependClasses(['JCAT.MVC.DataVerifier'],'JCAT.MVC.DataVerifier.LengthVerifier') ;

JCAT.MVC.DataVerifier.LengthVerifier = function(nMin,nMax,bAllowEmpty)
{
	this._nMin = nMin ;
	this._nMax = nMax ;
	this._bAllowEmpty = bAllowEmpty ;
}

JCAT.MVC.DataVerifier.LengthVerifier.prototype.VerifyData = function(aUICtrl)
{
	JCAT.Class.AssertHasImplements(aUICtrl,'JCAT.MVC.UICtrl.IForm') ;
	
	nDataLen = aUICtrl.GetDataLength() ;
	
	// 内容为空
	if( nDataLen==0 )
	{
		if( !this._bAllowEmpty  )
		{
			return JCAT.Language.Sentence('栏位“%s”未输入任何内容，该栏位不允许为空。','JCAT.JS',null,aUICtrl.GetUIName()) ;
		}
		
		else 
		{
			return true ;
		}
	}
	
	if( this._nMin>=0 && this._nMin>nDataLen )
	{
		return JCAT.Language.Sentence('栏位“%s”输入内容的长度不应小于 %d，输入长度为 %d。','JCAT.JS',null
			, aUICtrl.GetUIName(), this._nMin, nDataLen ) ;
	}
	
	if( this._nMax>=0 && this._nMax<nDataLen )
	{
		return JCAT.Language.Sentence('栏位“%s”输入内容的长度不应大于 %d，输入长度为 %d。','JCAT.JS',null
			, aUICtrl.GetUIName(), this._nMax, nDataLen ) ;
	}
	
	return true ;
}