JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.UICtrl','JCAT.MVC.UICtrl.IUICtrl'],'JCAT.MVC.UICtrl.IContainer') ;

JCAT.MVC.UICtrl.IContainer = function ()
{
	this._arrUICtrls = {} ;
}

JCAT.MVC.UICtrl.IContainer.prototype.AddUICtrl = function (aUICtrl)
{
	if( typeof(aUICtrl)!='object' || !JCAT.Class.HasImplements(aUICtrl,JCAT.MVC.UICtrl.IUICtrl) )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 aUICtrl 必须为实现接口 JCAT.MVC.IUICtrl 的对象','JCAT.JS',null)
		) ;	
	}

	var sName = aUICtrl.GetName() ;
	this._arrUICtrls[sName] = aUICtrl ;
}

JCAT.MVC.UICtrl.IContainer.prototype.GetUICtrl = function (sUICtrlName)
{
	if(typeof(this._arrUICtrls[sUICtrlName])!='undefine')
	{
		return this._arrUICtrls[sUICtrlName] ;
	}
	
	else
	{
		return null ;
	}
}


JCAT.MVC.UICtrl.IContainer.prototype.RemoveUICtrl = function (sUICtrlName)
{
	this._arrUICtrls[sUICtrlName] = null ;
}


JCAT.MVC.UICtrl.IContainer.prototype.ClearUICtrl = function ()
{
	this._arrUICtrls = {} ;
}
