JCAT.Class.CheckDependClasses(['JCAT.MVC.UICtrl.TextBase'],'JCAT.MVC.UICtrl.Select') ;

JCAT.MVC.UICtrl.Select = function (sName,sID,sUIName)
{
	this._wndInput = document.getElementById(sID) ;
	if( typeof(this._wndInput.tagName)=='undefined' || this._wndInput.tagName!='SELECT' )
	{
		throw new Error(
			JCAT.Language.Sentence('ID 为:%s 的Select控件不存在.','JCAT.JS',null,sID)
		) ;
	}
	
	this.TextBaseConstruct(sName,sID,sUIName) ;
}

// 继承
JCAT.Class.Inherit(JCAT.MVC.UICtrl.Select,JCAT.MVC.UICtrl.TextBase) ;

JCAT.MVC.UICtrl.Select.prototype.SetData = function (sValue)
{
	sOldValue = this.GetData() ;
	
	for(var nOpIdx in this._wndInput.options)
	{
		aOption = this._wndInput.options[nOpIdx] ;
		if(aOption.value==sValue)
		{
			aOption.selected = true ;
			return sOldValue ;
		}
	}
}

JCAT.MVC.UICtrl.Select.prototype.GetData = function ()
{
	if( this._wndInput.selectedIndex>=0 )
	{
		return this._wndInput.options[this._wndInput.selectedIndex].value ;
	}
	
	else
	{
		return null ;
	}
}

JCAT.MVC.UICtrl.Select.prototype.GetDataLength = function ()
{
	return this._wndInput.selectedIndex ;
}

JCAT.Class.AssertConcreteClass('JCAT.MVC.UICtrl.Select') ;