JCAT.Class.CheckDependClasses(['JCAT.MVC']) ;

JCAT.MVC.View.IContainer = function ()
{
	this._arrViews = {} ;
}

JCAT.MVC.View.IContainer.prototype.AddView = function (aView)
{
	JCAT.Class.CheckDependClasses(['JCAT.MVC.IView']) ;
	
	if( typeof(aView)!='object' || !JCAT.Class.HasImplements(aView,JCAT.MVC.IView) )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 aView 必须为实现接口 JCAT.MVC.IView 的对象','JCAT.JS',null)
		) ;	
	}

	var sName = aView.GetName() ;
	this._arrViews[sName] = aView ;
}

JCAT.MVC.View.IContainer.prototype.GetView = function (sViewName)
{
	if(typeof(this._arrViews[sViewName])!='undefine')
	{
		return this._arrViews[sViewName] ;
	}
	
	else
	{
		return null ;
	}
}

JCAT.MVC.View.IContainer.prototype.RemoveView = function (sViewName)
{
	this._arrViews[sViewName] = null ;
}

JCAT.MVC.View.IContainer.prototype.ClearView = function ()
{
	this._arrViews = {} ;
}
