JCAT.Class.CheckDependClasses(['JCAT.MVC.View'],'JCAT.MVC.View.IForm') ;

JCAT.MVC.View.ViewForm = function (sName,sFormName)
{
	if( typeof(sName)!='string' )
	{
		throw new Error(
			JCAT.Language.Sentence('JCAT.MVC.View.IForm() 参数 sName 必须为字符串.','JCAT.JS',null)
		);
	}
	if( typeof(sFormName)=='undefined' )
	{
		sFormName = sName+ 'Form' ;
	}
	
	this.ViewConstruct(sName) ;
	this._sFormName = sFormName ;
	
	// 接管 Form 的 OnSubmit 事件
	wndForm = this.GetForm() ;
	if( !wndForm )
	{
		throw new Error(
			JCAT.Language.Sentence('网页中不存在名为 %s 的Form元素,无法创建 Form视图.','JCAT.JS',null,sFormName)
		) ;
	}
	
	wndForm.onsubmit = JCAT.MVC.View.ViewForm.OnSubmit ;
	wndForm._JCAT_Object = this ;
}

// 继承自 JCAT.MVC.View
JCAT.Class.Inherit(JCAT.MVC.View.ViewForm,JCAT.MVC.View,'ViewConstruct') ;

// 实现接口 JCAT.MVC.View.IForm
JCAT.Class.Inherit(JCAT.MVC.View.ViewForm,JCAT.MVC.View.IForm) ;


// JCAT.MVC.View.ViewForm.OnSubmit() 将传递给 Html Form 对象,作为 Form对象的事件函数
JCAT.MVC.View.ViewForm.OnSubmit = function()
{
	try
	{
		if( this._JCAT_Object.VerifyData() )
		{
			// 触发事件
			this._JCAT_Object.BeforeSubmit() ;
			
			return true ;
		}
		
		else
		{
			return false ;
		}
	}
	catch(e)
	{
		alert(e) ;
		return false ;
	}
}
