
// 文件: class.MVC.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT']) ;
JCAT.Class.CreateAbstractClass('JCAT.MVC') ;




// 文件: UICtrl/class.UICtrl.declare.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC'],'JCAT.MVC.UICtrl') ;
JCAT.Class.CreateAbstractClass('JCAT.MVC.UICtrl') ;




// 文件: UICtrl/class.IUICtrl.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.UICtrl'],'JCAT.MVC.UICtrl.IUICtrl') ;

JCAT.MVC.UICtrl.IUICtrl = function (){}

JCAT.MVC.UICtrl.IUICtrl.prototype.GetName = function ()
{
	return this._sName ;
}

JCAT.MVC.UICtrl.IUICtrl.prototype.GetUIName = function ()
{
	return this._sUIName ;
}




// 文件: UICtrl/class.UICtrl.define.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.UICtrl','JCAT.MVC.UICtrl.IUICtrl'],'JCAT.MVC.UICtrl.BaseClass') ;

// 实现 JCAT.MVC.UICtrl.IUICtrl 接口
JCAT.Class.Inherit(JCAT.MVC.UICtrl,JCAT.MVC.UICtrl.IUICtrl) ;


// 构造函数
JCAT.MVC.UICtrl.prototype.UICtrlConstruct = function(sName,sID,sUIName)
{
	this._sName = sName ;
	this._sID = sID ;
	this._sUIName = sUIName ;
}




// 文件: UICtrl/class.IForm.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.UICtrl'],'JCAT.MVC.UICtrl.IForm') ;

JCAT.MVC.UICtrl.IForm = function()
{
	this._arrDataVerifies = new Array() ;
}

JCAT.Class.CreateAbstractMethod('JCAT.MVC.UICtrl.IForm.prototype.SetData') ;
JCAT.Class.CreateAbstractMethod('JCAT.MVC.UICtrl.IForm.prototype.GetData') ;
JCAT.Class.CreateAbstractMethod('JCAT.MVC.UICtrl.IForm.prototype.GetDataLength') ;


JCAT.MVC.UICtrl.IForm.prototype.AddDataVerifier = function (aDataVerifier)
{
	if( typeof(aDataVerifier)!='object' || !JCAT.Class.HasImplements(aDataVerifier,JCAT.MVC.DataVerifier.IDataVerifier) )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 aDataVerifier 必须为实现接口 JCAT.MVC.IDataVerifier 的对象。','JCAT.JS',null)
		) ;
	}
	
	this._arrDataVerifies.push(aDataVerifier) ;
}

JCAT.MVC.UICtrl.IForm.prototype.VerifyData = function ()
{
	for(var idx=0; idx<this._arrDataVerifies.length; idx++)
	{
		Result = this._arrDataVerifies[idx].VerifyData(this) ;
		if( Result!==true )
		{
			return Result ;
		}
	}
	
	return true ;
}

JCAT.MVC.UICtrl.IForm.prototype.BeforeSubmit = function()
{
	// do nothing
}




// 文件: UICtrl/class.IContainer.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.UICtrl','JCAT.MVC.UICtrl.IUICtrl'],'JCAT.MVC.UICtrl.IContainer') ;

JCAT.MVC.UICtrl.IContainer = function ()
{
	this._arrUICtrls = {} ;
}

JCAT.MVC.UICtrl.IContainer.prototype.AddUICtrl = function (aUICtrl)
{
	if( typeof(aUICtrl)!='object' || !JCAT.Class.HasImplements(aUICtrl,JCAT.MVC.UICtrl.IUICtrl) )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 aUICtrl 必须为实现接口 JCAT.MVC.IUICtrl 的对象','JCAT.JS',null)
		) ;	
	}

	var sName = aUICtrl.GetName() ;
	this._arrUICtrls[sName] = aUICtrl ;
}

JCAT.MVC.UICtrl.IContainer.prototype.GetUICtrl = function (sUICtrlName)
{
	if(typeof(this._arrUICtrls[sUICtrlName])!='undefine')
	{
		return this._arrUICtrls[sUICtrlName] ;
	}
	
	else
	{
		return null ;
	}
}


JCAT.MVC.UICtrl.IContainer.prototype.RemoveUICtrl = function (sUICtrlName)
{
	this._arrUICtrls[sUICtrlName] = null ;
}


JCAT.MVC.UICtrl.IContainer.prototype.ClearUICtrl = function ()
{
	this._arrUICtrls = {} ;
}





// 文件: UICtrl/class.TextBase.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC.UICtrl','JCAT.MVC.UICtrl.IUICtrl','JCAT.MVC.UICtrl.IForm'],'JCAT.MVC.UICtrl.TextBase') ;


// 创建抽象类
JCAT.Class.CreateAbstractClass('JCAT.MVC.UICtrl.TextBase') ;

// 继承
JCAT.Class.Inherit(JCAT.MVC.UICtrl.TextBase,JCAT.MVC.UICtrl) ;

// 实现 IForm 接口
JCAT.Class.Inherit(JCAT.MVC.UICtrl.TextBase,JCAT.MVC.UICtrl.IForm,'IFormConstruct') ;

// 定义常量
JCAT.MVC.UICtrl.TextBase.TXT_BYTE = 1 ;
JCAT.MVC.UICtrl.TextBase.TXT_CHAR = 2 ;

// 构造函数
JCAT.MVC.UICtrl.TextBase.prototype.TextBaseConstruct = function (sName,sID,sUIName)
{
	this._nVDTxtType = JCAT.MVC.UICtrl.TextBase.TXT_BYTE ;
	this.UICtrlConstruct(sName,sID,sUIName) ;
	this.IFormConstruct() ;
}

JCAT.MVC.UICtrl.TextBase.prototype.GetVDTxtType = function ()
{
	return this._nVDTxtType ;
}

JCAT.MVC.UICtrl.TextBase.prototype.SetVDTxtType = function (nTxtType)
{
	return this._nVDTxtType = nTxtType ;
}


JCAT.MVC.UICtrl.TextBase.prototype.SetData = function (sValue)
{
	this._wndInput.value = Value ;
}

JCAT.MVC.UICtrl.TextBase.prototype.GetData = function ()
{
	return this._wndInput.value ;
}

JCAT.MVC.UICtrl.TextBase.prototype.GetDataLength = function ()
{
	return (this.GetVDTxtType()==JCAT.MVC.UICtrl.TextBase.TXT_BYTE) ? 
			JCAT.String.GetStringByteLen(this._wndInput.value) :
			this._wndInput.value.length ;
}




// 文件: UICtrl/class.SText.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC.UICtrl.TextBase'],'JCAT.MVC.UICtrl.SText') ;

JCAT.MVC.UICtrl.SText = function (sName,sID,sUIName)
{
	this._wndInput = document.getElementById(sID) ;
	if( typeof(this._wndInput.tagName)=='undefined' || this._wndInput.tagName!='INPUT' )
	{
		throw new Error(
			JCAT.Language.Sentence('ID 为:%s 的Input控件不存在.','JCAT.JS',null,sID)
		) ;
	}
	
	this.TextBaseConstruct(sName,sID,sUIName) ;
}

// 继承
JCAT.Class.Inherit(JCAT.MVC.UICtrl.SText,JCAT.MVC.UICtrl.TextBase) ;
JCAT.Class.AssertConcreteClass('JCAT.MVC.UICtrl.SText') ;




// 文件: UICtrl/class.MText.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC.UICtrl.TextBase'],'JCAT.MVC.UICtrl.MText') ;

JCAT.MVC.UICtrl.MText = function (sName,sID,sUIName)
{
	this._wndInput = document.getElementById(sID) ;
	if( typeof(this._wndInput.tagName)=='undefined' || this._wndInput.tagName!='TEXTAREA' )
	{
		throw new Error(
			JCAT.Language.Sentence('ID 为:%s 的TextArea控件不存在.','JCAT.JS',null,sID)
		) ;
	}
	
	this.TextBaseConstruct(sName,sID,sUIName) ;
}

// 继承
JCAT.Class.Inherit(JCAT.MVC.UICtrl.MText,JCAT.MVC.UICtrl.TextBase) ;
JCAT.Class.AssertConcreteClass('JCAT.MVC.UICtrl.MText') ;




// 文件: UICtrl/class.Select.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC.UICtrl.TextBase'],'JCAT.MVC.UICtrl.Select') ;

JCAT.MVC.UICtrl.Select = function (sName,sID,sUIName)
{
	this._wndInput = document.getElementById(sID) ;
	if( typeof(this._wndInput.tagName)=='undefined' || this._wndInput.tagName!='SELECT' )
	{
		throw new Error(
			JCAT.Language.Sentence('ID 为:%s 的Select控件不存在.','JCAT.JS',null,sID)
		) ;
	}
	
	this.TextBaseConstruct(sName,sID,sUIName) ;
}

// 继承
JCAT.Class.Inherit(JCAT.MVC.UICtrl.Select,JCAT.MVC.UICtrl.TextBase) ;

JCAT.MVC.UICtrl.Select.prototype.SetData = function (sValue)
{
	sOldValue = this.GetData() ;
	
	for(var nOpIdx in this._wndInput.options)
	{
		aOption = this._wndInput.options[nOpIdx] ;
		if(aOption.value==sValue)
		{
			aOption.selected = true ;
			return sOldValue ;
		}
	}
}

JCAT.MVC.UICtrl.Select.prototype.GetData = function ()
{
	if( this._wndInput.selectedIndex>=0 )
	{
		return this._wndInput.options[this._wndInput.selectedIndex].value ;
	}
	
	else
	{
		return null ;
	}
}

JCAT.MVC.UICtrl.Select.prototype.GetDataLength = function ()
{
	return this._wndInput.selectedIndex ;
}

JCAT.Class.AssertConcreteClass('JCAT.MVC.UICtrl.Select') ;




// 文件: View/class.View.declare.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC']) ;
JCAT.MVC.View = function (sName)
{
	this._sName = sName ;	
	this.IViewConstruct() ;
}




// 文件: View/class.IContainer.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC']) ;

JCAT.MVC.View.IContainer = function ()
{
	this._arrViews = {} ;
}

JCAT.MVC.View.IContainer.prototype.AddView = function (aView)
{
	JCAT.Class.CheckDependClasses(['JCAT.MVC.IView']) ;
	
	if( typeof(aView)!='object' || !JCAT.Class.HasImplements(aView,JCAT.MVC.IView) )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 aView 必须为实现接口 JCAT.MVC.IView 的对象','JCAT.JS',null)
		) ;	
	}

	var sName = aView.GetName() ;
	this._arrViews[sName] = aView ;
}

JCAT.MVC.View.IContainer.prototype.GetView = function (sViewName)
{
	if(typeof(this._arrViews[sViewName])!='undefine')
	{
		return this._arrViews[sViewName] ;
	}
	
	else
	{
		return null ;
	}
}

JCAT.MVC.View.IContainer.prototype.RemoveView = function (sViewName)
{
	this._arrViews[sViewName] = null ;
}

JCAT.MVC.View.IContainer.prototype.ClearView = function ()
{
	this._arrViews = {} ;
}





// 文件: View/class.IView.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.View','JCAT.MVC.View.IContainer','JCAT.MVC.UICtrl.IContainer']) ;

JCAT.MVC.View.IView = function ()
{
	this.UICtrlContainer() ;
	this.ViewContainer() ;
}

JCAT.MVC.View.IView.prototype.GetName = function()
{
	return this._sName ;
}

JCAT.Class.Inherit(JCAT.MVC.View.IView,JCAT.MVC.View.IContainer,'ViewContainer') ;
JCAT.Class.Inherit(JCAT.MVC.View.IView,JCAT.MVC.UICtrl.IContainer,'UICtrlContainer') ;




// 文件: View/class.View.define.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.View','JCAT.MVC.View.IView'],'JCAT.MVC.View') ;

// 实现 JCAT.MVC.View.IView 接口
JCAT.Class.Inherit(JCAT.MVC.View,JCAT.MVC.View.IView,'IViewConstruct') ;




// 文件: View/class.IForm.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.View']) ;

JCAT.MVC.View.IForm = function(){} ;

JCAT.MVC.View.IForm.prototype.GetFormName = function()
{
	return this._sFormName ;
}

JCAT.MVC.View.IForm.prototype.GetForm = function()
{
	sFormName = this.GetFormName() ;
	return (typeof(document.forms[sFormName])=='undefined') ?
					null: document.forms[sFormName] ;
}

JCAT.MVC.View.IForm.prototype.VerifyData = function ( bFull/*=false*/, bAlert/*=true*/ )
{
	if( typeof(bFull)=='undefined' )
	{
		bFull = false ;
	}
	if( typeof(bAlert)=='undefined' )
	{
		bAlert = true ;
	}
	
	bReturn = true ;
	for(var sUICtrlName in this._arrUICtrls )
	{
		aUICtrl = this._arrUICtrls[sUICtrlName] ;
		if( JCAT.Class.HasImplements(aUICtrl,JCAT.MVC.UICtrl.IForm) )
		{
			Result = aUICtrl.VerifyData() ;
			if(Result!==true)
			{
				if(bAlert)
				{
					alert(Result) ;
				}
				
				bReturn = false ;
				
				if(!bFull)
				{
					break ;
				}
			}
		}
	}
	
	return bReturn ;
}


JCAT.MVC.View.IForm.prototype.BeforeSubmit = function ()
{
	for(var sUICtrlName in this._arrUICtrls )
	{
		aUICtrl = this._arrUICtrls[sUICtrlName] ;
		
		if( JCAT.Class.HasImplements(aUICtrl,JCAT.MVC.UICtrl.IForm) )
		{
			aUICtrl.BeforeSubmit() ;
		}
	}
}

JCAT.MVC.View.IForm.prototype.Submit = function()
{
	wndForm = this.GetForm() ;
	if(wndForm)
	{
		wndForm.submit() ;
	}
}





// 文件: View/class.ViewForm.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC.View'],'JCAT.MVC.View.IForm') ;

JCAT.MVC.View.ViewForm = function (sName,sFormName)
{
	if( typeof(sName)!='string' )
	{
		throw new Error(
			JCAT.Language.Sentence('JCAT.MVC.View.IForm() 参数 sName 必须为字符串.','JCAT.JS',null)
		);
	}
	if( typeof(sFormName)=='undefined' )
	{
		sFormName = sName+ 'Form' ;
	}
	
	this.ViewConstruct(sName) ;
	this._sFormName = sFormName ;
	
	// 接管 Form 的 OnSubmit 事件
	wndForm = this.GetForm() ;
	if( !wndForm )
	{
		throw new Error(
			JCAT.Language.Sentence('网页中不存在名为 %s 的Form元素,无法创建 Form视图.','JCAT.JS',null,sFormName)
		) ;
	}
	
	wndForm.onsubmit = JCAT.MVC.View.ViewForm.OnSubmit ;
	wndForm._JCAT_Object = this ;
}

// 继承自 JCAT.MVC.View
JCAT.Class.Inherit(JCAT.MVC.View.ViewForm,JCAT.MVC.View,'ViewConstruct') ;

// 实现接口 JCAT.MVC.View.IForm
JCAT.Class.Inherit(JCAT.MVC.View.ViewForm,JCAT.MVC.View.IForm) ;


// JCAT.MVC.View.ViewForm.OnSubmit() 将传递给 Html Form 对象,作为 Form对象的事件函数
JCAT.MVC.View.ViewForm.OnSubmit = function()
{
	try
	{
		if( this._JCAT_Object.VerifyData() )
		{
			// 触发事件
			this._JCAT_Object.BeforeSubmit() ;
			
			return true ;
		}
		
		else
		{
			return false ;
		}
	}
	catch(e)
	{
		alert(e) ;
		return false ;
	}
}





// 文件: DataVerifier/class.DataVerifier.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC'],'JCAT.MVC.DataVerifier') ;
JCAT.Class.CreateAbstractClass('JCAT.MVC.DataVerifier') ;




// 文件: DataVerifier/class.IDataVerifier.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC','JCAT.MVC.DataVerifier']) ;

JCAT.MVC.DataVerifier.IDataVerifier = function (){}
JCAT.Class.CreateAbstractMethod('JCAT.MVC.DataVerifier.IDataVerifier.prototype.VerifyData') ;




// 文件: DataVerifier/class.LengthVerifier.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC.DataVerifier'],'JCAT.MVC.DataVerifier.LengthVerifier') ;

JCAT.MVC.DataVerifier.LengthVerifier = function(nMin,nMax,bAllowEmpty)
{
	this._nMin = nMin ;
	this._nMax = nMax ;
	this._bAllowEmpty = bAllowEmpty ;
}

JCAT.MVC.DataVerifier.LengthVerifier.prototype.VerifyData = function(aUICtrl)
{
	JCAT.Class.AssertHasImplements(aUICtrl,'JCAT.MVC.UICtrl.IForm') ;
	
	nDataLen = aUICtrl.GetDataLength() ;
	
	// 内容为空
	if( nDataLen==0 )
	{
		if( !this._bAllowEmpty  )
		{
			return JCAT.Language.Sentence('栏位“%s”未输入任何内容，该栏位不允许为空。','JCAT.JS',null,aUICtrl.GetUIName()) ;
		}
		
		else 
		{
			return true ;
		}
	}
	
	if( this._nMin>=0 && this._nMin>nDataLen )
	{
		return JCAT.Language.Sentence('栏位“%s”输入内容的长度不应小于 %d，输入长度为 %d。','JCAT.JS',null
			, aUICtrl.GetUIName(), this._nMin, nDataLen ) ;
	}
	
	if( this._nMax>=0 && this._nMax<nDataLen )
	{
		return JCAT.Language.Sentence('栏位“%s”输入内容的长度不应大于 %d，输入长度为 %d。','JCAT.JS',null
			, aUICtrl.GetUIName(), this._nMax, nDataLen ) ;
	}
	
	return true ;
}




// 文件: DataVerifier/class.RepeatVerifier.js 
// ----------------------------------------------------------------------------------------
JCAT.Class.CheckDependClasses(['JCAT.MVC.DataVerifier'],'JCAT.MVC.DataVerifier.RepeatVerifier') ;

JCAT.MVC.DataVerifier.RepeatVerifier = function(aUICtrl)
{
	JCAT.Class.AssertHasImplements(aUICtrl,'JCAT.MVC.UICtrl.IForm') ;
	this.aUICtrl = aUICtrl ;
}

JCAT.MVC.DataVerifier.RepeatVerifier.prototype.VerifyData = function(aAnotherUICtrl)
{
	JCAT.Class.AssertHasImplements(aAnotherUICtrl,'JCAT.MVC.UICtrl.IForm') ;
	if (aAnotherUICtrl.GetData() == this.aUICtrl.GetData())
	{
		return true ;
	}
	
	else
	{
		return JCAT.Language.Sentence('栏位“%s”和“%s”输入的内容不一致。','JCAT.JS',null
			, aUICtrl.GetUIName(), aAnotherUICtrl.GetUIName(), this.aUICtrl.GetUIName() ) ;
	}
}



