function LanguageFuntion()
{
	this._arrLanguagePackage = {} ;
	
	this._sCurrentLanguage = 'cn' ;
}

LanguageFuntion.prototype.Sentence = function (sSentence,sPackageName,sLanguageName/*=null*/)
{
	if( typeof(sSentence)!='string' )
	{
		throw new Error('sSentence must be a string!') ;
	}
	if( typeof(sPackageName)!='string' )
	{
		throw new Error('sPackageName must be a string!') ;
	}

	// sLanguageName 缺省使用当前语言
	if( typeof(sLanguageName)=='undefined' || sLanguageName==null )
	{
		sLanguageName = this.GetCurrentLanguage() ;
	}
	
	// 取得语言包中的语句
	sSentenceForThisLanguage = this._GetSentence(sSentence,sLanguageName,sPackageName) ;
	
	// 带入参数
	arrFormatArgs = [] ;
	for(nIdx=3; nIdx<arguments.length; nIdx++)
	{
		arrFormatArgs.push( arguments[nIdx] ) ;
	}
	if(arrFormatArgs.length)
	{
		return JCAT.String.Format(sSentenceForThisLanguage,arrFormatArgs) ;
	}
	
	else
	{
		return sSentenceForThisLanguage ;
	}
}

LanguageFuntion.prototype.SaveNewSentence = function (sSentenceKey,sSentence,sLanguageName,sPackageName/*=null*/)
{
	sResult = JCAT.SOAP.SSMI.Invoke('JCAT_LanguagePackageForClient','SetNewSentence',[sSentenceKey,sSentence,sLanguageName,sPackageName]) ;
	if(sResult=='1')
	{
		return true ;
	}
	
	throw new Error(sResult) ;
}

LanguageFuntion.prototype.SetCurrentLanguage = function(sLanguageName)
{
	this._sCurrentLanguage = sLanguageName ;
}

LanguageFuntion.prototype.GetCurrentLanguage = function()
{
	return this._sCurrentLanguage ;
}

LanguageFuntion.prototype.MakeSentenceKey = function (sSentence)
{
	return JCAT.String.MD5(sSentence) ;
}


// Private //////////////////////////////////////////////////////////

LanguageFuntion.prototype._GetSentence = function (sSentence,sLanguageName,sPackageName)
{
	// 确保语言包已被载入
	if( typeof(this._arrLanguagePackage[sLanguageName])=='undefined' || typeof(this._arrLanguagePackage[sLanguageName][sPackageName])=='undefined' )
	{
		this._LoadPackage(sLanguageName,sPackageName) ;
	}
	
	
	sSentenceKey = this.MakeSentenceKey(sSentence) ;
	
	// 保存 语言包中不存在的 新语句
	if (typeof(this._arrLanguagePackage[sLanguageName][sPackageName][sSentenceKey])=='undefined')
	{
		this._arrLanguagePackage[sLanguageName][sPackageName][sSentenceKey] = sSentence ;

		// 传递给 PHP 保存
		this.SaveNewSentence(sSentenceKey,sSentence,sLanguageName,sPackageName) ;
	}
	
	return this._arrLanguagePackage[sLanguageName][sPackageName][sSentenceKey] ;
}

LanguageFuntion.prototype._LoadPackage = function (sLanguageName,sPackageName)
{
	// 
	if( typeof(this._arrLanguagePackage[sLanguageName])=='undefined' )
	{
		this._arrLanguagePackage[sLanguageName] = {} ;
	}
	
	//
	if( typeof(this._arrLanguagePackage[sLanguageName][sPackageName])=='undefined' )
	{		
		// 下载语言包
		sSentensesJSON = JCAT.SOAP.SSMI.Invoke('JCAT_LanguagePackageForClient','GetLanguagePackage',[sLanguageName,sPackageName]) ;
		
		// 载入
		if( sSentensesJSON )
		{
			sScript = 'this._arrLanguagePackage[sLanguageName][sPackageName] = '+sSentensesJSON ;
			
			try{
				eval(sScript) ;
			}
			
			catch(e)
			{
				throw '无法载入语言包：'+sPackageName+'/'+sLanguageName+"\r\n请检查 JCAT Framework 的配置" ;
			}
		}
		
		else
		{
			this._arrLanguagePackage[sLanguageName][sPackageName] = {} ;
		}
	}
}




window.JCAT.Language = new LanguageFuntion() ;



