
// 文件: class.JCAT.js 
// ----------------------------------------------------------------------------------------
window.JCAT = function(){} ;
window.JCAT.Version = '0.3' ;




// 文件: SOAP/class.SOAP.js 
// ----------------------------------------------------------------------------------------
function SOAP()
{
}

window.JCAT.SOAP = new Object() ;




// 文件: SOAP/class.XMLHttp.js 
// ----------------------------------------------------------------------------------------
window.JCAT.SOAP.XMLHttp = function ()
{
}

window.JCAT.SOAP.XMLHttp.CreateHTTP = function ()
{
	var aXMLHttp = null; 
	if (window.XMLHttpRequest)
	{ 
		aXMLHttp = new XMLHttpRequest(); 
	} 
	if (!aXMLHttp&&window.ActiveXObject) 
	{ 
	    try 
	    { 
	        aXMLHttp = new ActiveXObject("Msxml2.XMLHTTP.5.0") 
	    } 
	    catch(e) 
	    { 
	        try 
	        { 
	            aXMLHttp = new ActiveXObject("Msxml2.XMLHTTP.4.0") 
	        } 
	        catch(e) 
	        { 
	            try 
	            { 
	                aXMLHttp = new ActiveXObject("Msxml2.XMLHTTP") 
	            } 
	            catch(e) 
	            { 
					try
					{
						aXMLHttp = new ActiveXObject("Microsoft.XMLHTTP")
					}
					catch(e)
					{
						alert("The Browser Not Support XMLHttp。");
					} 
	            } 
	        } 
	    } 
	}
	
	return aXMLHttp ;
}

window.JCAT.SOAP.XMLHttp.CreateDOM = function ()
{
	// code for IE
	if (window.ActiveXObject)
	{
		return new ActiveXObject("Microsoft.XMLDOM");
	}
	
	// code for Mozilla, etc.
	else if(document.implementation && document.implementation.createDocument)
	{
		return document.implementation.createDocument("","",null);
	}
}




// 文件: SOAP/class.SSMI.js 
// ----------------------------------------------------------------------------------------
window.JCAT.SOAP.SSMI = function ()
{
}

window.JCAT.SOAP.SSMI.Invoke = function (sClassName,sMethodName,arrParams,bAsyn)
{
	if( typeof(bAsyn)=='undefined' )
	{
		bAsyn = false ;
	}
	
	sUrl = this.GetRequestURL(sClassName,sMethodName,arrParams) ;
	
	// 发送请求并返回
	aXMLHttp = JCAT.SOAP.XMLHttp.CreateHTTP() ;
	
	aXMLHttp.open("GET",sUrl,bAsyn) ;
	aXMLHttp.setRequestHeader("CONTENT-TYPE","application/x-www-form-urlencoded") ;	//如果需要 get/post 中文參數到服務器，必須出現此行，否則服務器端出現編碼錯誤。
	
	aXMLHttp.send(null);
	
	if(!bAsyn)
	{
		return aXMLHttp.responseText ;
	}
}

window.JCAT.SOAP.SSMI.GetRequestURL = function (sClassName,sMethodName,arrParams)
{
	if( typeof(arrParams)=='undefined' )
	{
		arrParams = [] ;
	}
	
	if( !(arrParams instanceof Array) )
	{
		throw new Error('arrParams must be a Array!') ;
	}
	
	// API
	sUrl = window.JCAT.SOAP.SSMI.INTERFACE_PATH + '?controller=JCAT_SSMI&Class='+sClassName+'&Method='+sMethodName ;
	
	// 参数
	for(i=0;i<arrParams.length;i++)
	{
		sUrl+= '&Param%5B%5D='+arrParams[i] ;
	}
	
	return sUrl ;
}

window.JCAT.SOAP.SSMI.INTERFACE_PATH = '/' ;




// 文件: class.String.js 
// ----------------------------------------------------------------------------------------
JCAT.String = function()
{
}


JCAT.String.GetStringByteLen = function (sString)
{
	if( typeof(sString)!='string' )
	{
		return 0 ;
	}

	var nLen = 0 ;
	var i;
	for (i=0;i<sString.length;i++)
	{
		if (sString.charCodeAt(i)>255)
		{
			nLen+=3 ;
		}
		else
		{
			nLen++ ;
		}
	}
	
	return nLen ;
}

JCAT.String.Format = function (format,args)
{
    // http://kevin.vanzonneveld.net
    // +   original by: Ash Searle (http://hexmen.com/blog/)
    // + namespaced by: Michael White (http://crestidg.com)
    // *     example 1: sprintf("%01.2f", 123.1);
    // *     returns 1: 123.10
 
    var regex = /%%|%(\d+\$)?([-+#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuidfegEG])/g;
    // var a = arguments, i = 0, format = a[i++];
    var i = 0 ;
    var a = args ;
 
    // pad()
    var pad = function(str, len, chr, leftJustify) {
        var padding = (str.length >= len) ? '' : Array(1 + len - str.length >>> 0).join(chr);
        return leftJustify ? str + padding : padding + str;
    };
 
    // justify()
    var justify = function(value, prefix, leftJustify, minWidth, zeroPad) {
        var diff = minWidth - value.length;
        if (diff > 0) {
            if (leftJustify || !zeroPad) {
            value = pad(value, minWidth, ' ', leftJustify);
            } else {
            value = value.slice(0, prefix.length) + pad('', diff, '0', true) + value.slice(prefix.length);
            }
        }
        return value;
    };
 
    // formatBaseX()
    var formatBaseX = function(value, base, prefix, leftJustify, minWidth, precision, zeroPad) {
        // Note: casts negative numbers to positive ones
        var number = value >>> 0;
        prefix = prefix && number && {'2': '0b', '8': '0', '16': '0x'}[base] || '';
        value = prefix + pad(number.toString(base), precision || 0, '0', false);
        return justify(value, prefix, leftJustify, minWidth, zeroPad);
    };
 
    // formatString()
    var formatString = function(value, leftJustify, minWidth, precision, zeroPad) {
        if (precision != null) {
            value = value.slice(0, precision);
        }
        return justify(value, '', leftJustify, minWidth, zeroPad);
    };
 
    // finalFormat()
    var doFormat = function(substring, valueIndex, flags, minWidth, _, precision, type) {
        if (substring == '%%') return '%';
 
        // parse flags
        var leftJustify = false, positivePrefix = '', zeroPad = false, prefixBaseX = false;
        for (var j = 0; flags && j < flags.length; j++) switch (flags.charAt(j)) {
            case ' ': positivePrefix = ' '; break;
            case '+': positivePrefix = '+'; break;
            case '-': leftJustify = true; break;
            case '0': zeroPad = true; break;
            case '#': prefixBaseX = true; break;
        }
 
        // parameters may be null, undefined, empty-string or real valued
        // we want to ignore null, undefined and empty-string values
        if (!minWidth) {
            minWidth = 0;
        } else if (minWidth == '*') {
            minWidth = +a[i++];
        } else if (minWidth.charAt(0) == '*') {
            minWidth = +a[minWidth.slice(1, -1)];
        } else {
            minWidth = +minWidth;
        }
 
        // Note: undocumented perl feature:
        if (minWidth < 0) {
            minWidth = -minWidth;
            leftJustify = true;
        }
 
        if (!isFinite(minWidth)) {
            throw new Error('JCAT.Language.Format: (minimum-)width must be finite');
        }
 
        if (!precision) {
            precision = 'fFeE'.indexOf(type) > -1 ? 6 : (type == 'd') ? 0 : void(0);
        } else if (precision == '*') {
            precision = +a[i++];
        } else if (precision.charAt(0) == '*') {
            precision = +a[precision.slice(1, -1)];
        } else {
            precision = +precision;
        }
 
        // grab value using valueIndex if required?
        var value = valueIndex ? a[valueIndex.slice(0, -1)] : a[i++];
 
        switch (type) {
            case 's': return formatString(String(value), leftJustify, minWidth, precision, zeroPad);
            case 'c': return formatString(String.fromCharCode(+value), leftJustify, minWidth, precision, zeroPad);
            case 'b': return formatBaseX(value, 2, prefixBaseX, leftJustify, minWidth, precision, zeroPad);
            case 'o': return formatBaseX(value, 8, prefixBaseX, leftJustify, minWidth, precision, zeroPad);
            case 'x': return formatBaseX(value, 16, prefixBaseX, leftJustify, minWidth, precision, zeroPad);
            case 'X': return formatBaseX(value, 16, prefixBaseX, leftJustify, minWidth, precision, zeroPad).toUpperCase();
            case 'u': return formatBaseX(value, 10, prefixBaseX, leftJustify, minWidth, precision, zeroPad);
            case 'i':
            case 'd': {
                        var number = parseInt(+value);
                        var prefix = number < 0 ? '-' : positivePrefix;
                        value = prefix + pad(String(Math.abs(number)), precision, '0', false);
                        return justify(value, prefix, leftJustify, minWidth, zeroPad);
                    }
            case 'e':
            case 'E':
            case 'f':
            case 'F':
            case 'g':
            case 'G':
                        {
                        var number = +value;
                        var prefix = number < 0 ? '-' : positivePrefix;
                        var method = ['toExponential', 'toFixed', 'toPrecision']['efg'.indexOf(type.toLowerCase())];
                        var textTransform = ['toString', 'toUpperCase']['eEfFgG'.indexOf(type) % 2];
                        value = prefix + Math.abs(number)[method](precision);
                        return justify(value, prefix, leftJustify, minWidth, zeroPad)[textTransform]();
                    }
            default: return substring;
        }
    };
 
    return format.replace(regex, doFormat);
}


JCAT.String.MD5 = function (sMessage) { 
function RotateLeft(lValue, iShiftBits) { return (lValue<<iShiftBits) | (lValue>>>(32-iShiftBits)); } 
function AddUnsigned(lX,lY) { 
var lX4,lY4,lX8,lY8,lResult; 
lX8 = (lX & 0x80000000); 
lY8 = (lY & 0x80000000); 
lX4 = (lX & 0x40000000); 
lY4 = (lY & 0x40000000); 
lResult = (lX & 0x3FFFFFFF)+(lY & 0x3FFFFFFF); 
if (lX4 & lY4) return (lResult ^ 0x80000000 ^ lX8 ^ lY8); 
if (lX4 | lY4) { 
if (lResult & 0x40000000) return (lResult ^ 0xC0000000 ^ lX8 ^ lY8); 
else return (lResult ^ 0x40000000 ^ lX8 ^ lY8); 
} else return (lResult ^ lX8 ^ lY8); 
} 
function F(x,y,z) { return (x & y) | ((~x) & z); } 
function G(x,y,z) { return (x & z) | (y & (~z)); } 
function H(x,y,z) { return (x ^ y ^ z); } 
function I(x,y,z) { return (y ^ (x | (~z))); } 
function FF(a,b,c,d,x,s,ac) { 
a = AddUnsigned(a, AddUnsigned(AddUnsigned(F(b, c, d), x), ac)); 
return AddUnsigned(RotateLeft(a, s), b); 
} 
function GG(a,b,c,d,x,s,ac) { 
a = AddUnsigned(a, AddUnsigned(AddUnsigned(G(b, c, d), x), ac)); 
return AddUnsigned(RotateLeft(a, s), b); 
} 
function HH(a,b,c,d,x,s,ac) { 
a = AddUnsigned(a, AddUnsigned(AddUnsigned(H(b, c, d), x), ac)); 
return AddUnsigned(RotateLeft(a, s), b); 
} 
function II(a,b,c,d,x,s,ac) { 
a = AddUnsigned(a, AddUnsigned(AddUnsigned(I(b, c, d), x), ac)); 
return AddUnsigned(RotateLeft(a, s), b); 
} 
function ConvertToWordArray(sMessage) { 
var lWordCount; 
var lMessageLength = sMessage.length; 
var lNumberOfWords_temp1=lMessageLength + 8; 
var lNumberOfWords_temp2=(lNumberOfWords_temp1-(lNumberOfWords_temp1 % 64))/64; 
var lNumberOfWords = (lNumberOfWords_temp2+1)*16; 
var lWordArray=Array(lNumberOfWords-1); 
var lBytePosition = 0; 
var lByteCount = 0; 
while ( lByteCount < lMessageLength ) { 
lWordCount = (lByteCount-(lByteCount % 4))/4; 
lBytePosition = (lByteCount % 4)*8; 
lWordArray[lWordCount] = (lWordArray[lWordCount] | (sMessage.charCodeAt(lByteCount)<<lBytePosition)); 
lByteCount++; 
} 
lWordCount = (lByteCount-(lByteCount % 4))/4; 
lBytePosition = (lByteCount % 4)*8; 
lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80<<lBytePosition); 
lWordArray[lNumberOfWords-2] = lMessageLength<<3; 
lWordArray[lNumberOfWords-1] = lMessageLength>>>29; 
return lWordArray; 
} 
function WordToHex(lValue) { 
var WordToHexValue="",WordToHexValue_temp="",lByte,lCount; 
for (lCount = 0;lCount<=3;lCount++) { 
lByte = (lValue>>>(lCount*8)) & 255; 
WordToHexValue_temp = "0" + lByte.toString(16); 
WordToHexValue = WordToHexValue + WordToHexValue_temp.substr(WordToHexValue_temp.length-2,2); 
} 
return WordToHexValue; 
} 
var x=Array(); 
var k,AA,BB,CC,DD,a,b,c,d 
var S11=7, S12=12, S13=17, S14=22; 
var S21=5, S22=9 , S23=14, S24=20; 
var S31=4, S32=11, S33=16, S34=23; 
var S41=6, S42=10, S43=15, S44=21; 
// Steps 1 and 2. Append padding bits and length and convert to words 
x = ConvertToWordArray(sMessage); 
// Step 3. Initialise 
a = 0x67452301; b = 0xEFCDAB89; c = 0x98BADCFE; d = 0x10325476; 
// Step 4. Process the message in 16-word blocks 
for (k=0;k<x.length;k+=16) { 
AA=a; BB=b; CC=c; DD=d; 
a=FF(a,b,c,d,x[k+0], S11,0xD76AA478); 
d=FF(d,a,b,c,x[k+1], S12,0xE8C7B756); 
c=FF(c,d,a,b,x[k+2], S13,0x242070DB); 
b=FF(b,c,d,a,x[k+3], S14,0xC1BDCEEE); 
a=FF(a,b,c,d,x[k+4], S11,0xF57C0FAF); 
d=FF(d,a,b,c,x[k+5], S12,0x4787C62A); 
c=FF(c,d,a,b,x[k+6], S13,0xA8304613); 
b=FF(b,c,d,a,x[k+7], S14,0xFD469501); 
a=FF(a,b,c,d,x[k+8], S11,0x698098D8); 
d=FF(d,a,b,c,x[k+9], S12,0x8B44F7AF); 
c=FF(c,d,a,b,x[k+10],S13,0xFFFF5BB1); 
b=FF(b,c,d,a,x[k+11],S14,0x895CD7BE); 
a=FF(a,b,c,d,x[k+12],S11,0x6B901122); 
d=FF(d,a,b,c,x[k+13],S12,0xFD987193); 
c=FF(c,d,a,b,x[k+14],S13,0xA679438E); 
b=FF(b,c,d,a,x[k+15],S14,0x49B40821); 
a=GG(a,b,c,d,x[k+1], S21,0xF61E2562); 
d=GG(d,a,b,c,x[k+6], S22,0xC040B340); 
c=GG(c,d,a,b,x[k+11],S23,0x265E5A51); 
b=GG(b,c,d,a,x[k+0], S24,0xE9B6C7AA); 
a=GG(a,b,c,d,x[k+5], S21,0xD62F105D); 
d=GG(d,a,b,c,x[k+10],S22,0x2441453); 
c=GG(c,d,a,b,x[k+15],S23,0xD8A1E681); 
b=GG(b,c,d,a,x[k+4], S24,0xE7D3FBC8); 
a=GG(a,b,c,d,x[k+9], S21,0x21E1CDE6); 
d=GG(d,a,b,c,x[k+14],S22,0xC33707D6); 
c=GG(c,d,a,b,x[k+3], S23,0xF4D50D87); 
b=GG(b,c,d,a,x[k+8], S24,0x455A14ED); 
a=GG(a,b,c,d,x[k+13],S21,0xA9E3E905); 
d=GG(d,a,b,c,x[k+2], S22,0xFCEFA3F8); 
c=GG(c,d,a,b,x[k+7], S23,0x676F02D9); 
b=GG(b,c,d,a,x[k+12],S24,0x8D2A4C8A); 
a=HH(a,b,c,d,x[k+5], S31,0xFFFA3942); 
d=HH(d,a,b,c,x[k+8], S32,0x8771F681); 
c=HH(c,d,a,b,x[k+11],S33,0x6D9D6122); 
b=HH(b,c,d,a,x[k+14],S34,0xFDE5380C); 
a=HH(a,b,c,d,x[k+1], S31,0xA4BEEA44); 
d=HH(d,a,b,c,x[k+4], S32,0x4BDECFA9); 
c=HH(c,d,a,b,x[k+7], S33,0xF6BB4B60); 
b=HH(b,c,d,a,x[k+10],S34,0xBEBFBC70); 
a=HH(a,b,c,d,x[k+13],S31,0x289B7EC6); 
d=HH(d,a,b,c,x[k+0], S32,0xEAA127FA); 
c=HH(c,d,a,b,x[k+3], S33,0xD4EF3085); 
b=HH(b,c,d,a,x[k+6], S34,0x4881D05); 
a=HH(a,b,c,d,x[k+9], S31,0xD9D4D039); 
d=HH(d,a,b,c,x[k+12],S32,0xE6DB99E5); 
c=HH(c,d,a,b,x[k+15],S33,0x1FA27CF8); 
b=HH(b,c,d,a,x[k+2], S34,0xC4AC5665); 
a=II(a,b,c,d,x[k+0], S41,0xF4292244); 
d=II(d,a,b,c,x[k+7], S42,0x432AFF97); 
c=II(c,d,a,b,x[k+14],S43,0xAB9423A7); 
b=II(b,c,d,a,x[k+5], S44,0xFC93A039); 
a=II(a,b,c,d,x[k+12],S41,0x655B59C3); 
d=II(d,a,b,c,x[k+3], S42,0x8F0CCC92); 
c=II(c,d,a,b,x[k+10],S43,0xFFEFF47D); 
b=II(b,c,d,a,x[k+1], S44,0x85845DD1); 
a=II(a,b,c,d,x[k+8], S41,0x6FA87E4F); 
d=II(d,a,b,c,x[k+15],S42,0xFE2CE6E0); 
c=II(c,d,a,b,x[k+6], S43,0xA3014314); 
b=II(b,c,d,a,x[k+13],S44,0x4E0811A1); 
a=II(a,b,c,d,x[k+4], S41,0xF7537E82); 
d=II(d,a,b,c,x[k+11],S42,0xBD3AF235); 
c=II(c,d,a,b,x[k+2], S43,0x2AD7D2BB); 
b=II(b,c,d,a,x[k+9], S44,0xEB86D391); 
a=AddUnsigned(a,AA); b=AddUnsigned(b,BB); c=AddUnsigned(c,CC); d=AddUnsigned(d,DD); 
} 
// Step 5. Output the 128 bit digest 
var temp= WordToHex(a)+WordToHex(b)+WordToHex(c)+WordToHex(d); 
return temp.toLowerCase(); 
} 





// 文件: class.Script.js 
// ----------------------------------------------------------------------------------------
window.JCAT.Script = function ()
{}



window.JCAT.Script.Load = function (sSrc)
{
	var aElementCollection = document.getElementsByTagName('head') ;
	if(aElementCollection.length==0)
	{
		throw new Error("Current Page Hasn't Head tag.");
	}
	else
	{
		var aHead = aElementCollection[0];
	}
	
	var aScript = document.createElement('script');
	aScript.type = "text/javascript";
	aScript.src = sSrc ;
	aHead.appendChild(aScript);
}


window.JCAT.Script.Import = function (sClassName)
{
	sSrc = JCAT.SOAP.SSMI.GetRequestURL('JCAT_Package','ImportJSClass',[sClassName]) ;
	this.Load(sSrc) ;
	
	var bSuc = false ;
	eval("bSuc = (typeof("+sClassName+")=='undefined')") ;
	return bSuc ;
}





// 文件: class.Language.js 
// ----------------------------------------------------------------------------------------
function LanguageFuntion()
{
	this._arrLanguagePackage = {} ;
	
	this._sCurrentLanguage = 'cn' ;
}

LanguageFuntion.prototype.Sentence = function (sSentence,sPackageName,sLanguageName/*=null*/)
{
	if( typeof(sSentence)!='string' )
	{
		throw new Error('sSentence must be a string!') ;
	}
	if( typeof(sPackageName)!='string' )
	{
		throw new Error('sPackageName must be a string!') ;
	}

	// sLanguageName 缺省使用当前语言
	if( typeof(sLanguageName)=='undefined' || sLanguageName==null )
	{
		sLanguageName = this.GetCurrentLanguage() ;
	}
	
	// 取得语言包中的语句
	sSentenceForThisLanguage = this._GetSentence(sSentence,sLanguageName,sPackageName) ;
	
	// 带入参数
	arrFormatArgs = [] ;
	for(nIdx=3; nIdx<arguments.length; nIdx++)
	{
		arrFormatArgs.push( arguments[nIdx] ) ;
	}
	if(arrFormatArgs.length)
	{
		return JCAT.String.Format(sSentenceForThisLanguage,arrFormatArgs) ;
	}
	
	else
	{
		return sSentenceForThisLanguage ;
	}
}

LanguageFuntion.prototype.SaveNewSentence = function (sSentenceKey,sSentence,sLanguageName,sPackageName/*=null*/)
{
	sResult = JCAT.SOAP.SSMI.Invoke('JCAT_LanguagePackageForClient','SetNewSentence',[sSentenceKey,sSentence,sLanguageName,sPackageName]) ;
	if(sResult=='1')
	{
		return true ;
	}
	
	throw new Error(sResult) ;
}

LanguageFuntion.prototype.SetCurrentLanguage = function(sLanguageName)
{
	this._sCurrentLanguage = sLanguageName ;
}

LanguageFuntion.prototype.GetCurrentLanguage = function()
{
	return this._sCurrentLanguage ;
}

LanguageFuntion.prototype.MakeSentenceKey = function (sSentence)
{
	return JCAT.String.MD5(sSentence) ;
}


// Private //////////////////////////////////////////////////////////

LanguageFuntion.prototype._GetSentence = function (sSentence,sLanguageName,sPackageName)
{
	// 确保语言包已被载入
	if( typeof(this._arrLanguagePackage[sLanguageName])=='undefined' || typeof(this._arrLanguagePackage[sLanguageName][sPackageName])=='undefined' )
	{
		this._LoadPackage(sLanguageName,sPackageName) ;
	}
	
	
	sSentenceKey = this.MakeSentenceKey(sSentence) ;
	
	// 保存 语言包中不存在的 新语句
	if (typeof(this._arrLanguagePackage[sLanguageName][sPackageName][sSentenceKey])=='undefined')
	{
		this._arrLanguagePackage[sLanguageName][sPackageName][sSentenceKey] = sSentence ;

		// 传递给 PHP 保存
		this.SaveNewSentence(sSentenceKey,sSentence,sLanguageName,sPackageName) ;
	}
	
	return this._arrLanguagePackage[sLanguageName][sPackageName][sSentenceKey] ;
}

LanguageFuntion.prototype._LoadPackage = function (sLanguageName,sPackageName)
{
	// 
	if( typeof(this._arrLanguagePackage[sLanguageName])=='undefined' )
	{
		this._arrLanguagePackage[sLanguageName] = {} ;
	}
	
	//
	if( typeof(this._arrLanguagePackage[sLanguageName][sPackageName])=='undefined' )
	{		
		// 下载语言包
		sSentensesJSON = JCAT.SOAP.SSMI.Invoke('JCAT_LanguagePackageForClient','GetLanguagePackage',[sLanguageName,sPackageName]) ;
		
		// 载入
		if( sSentensesJSON )
		{
			sScript = 'this._arrLanguagePackage[sLanguageName][sPackageName] = '+sSentensesJSON ;
			
			try{
				eval(sScript) ;
			}
			
			catch(e)
			{
				throw '无法载入语言包：'+sPackageName+'/'+sLanguageName+"\r\n请检查 JCAT Framework 的配置" ;
			}
		}
		
		else
		{
			this._arrLanguagePackage[sLanguageName][sPackageName] = {} ;
		}
	}
}




window.JCAT.Language = new LanguageFuntion() ;








// 文件: class.Class.js 
// ----------------------------------------------------------------------------------------
JCAT.Class = function()
{
}

JCAT.Class.CreateAbstractMethod = function (sFullMethodName)
{
	sCode = sFullMethodName + " = function ()\r\n" ;
	sCode+= "{var what_this='--this abstract a method--' ;\r\n" ;
	sCode+= "	throw new Error( JCAT.Language.Sentence('错误：正在访问一个抽象方法 %s。','JCAT.JS',null,'"+sFullMethodName+"') ) ;\r\n" ;
	sCode+= "}\r\n" ;

	eval(sCode) ;
}

JCAT.Class.CreateAbstractClass = function (sClassName)
{
	sCode = sClassName + " = function ()\r\n" ;
	sCode+= "{\r\n" ;
	sCode+= "	throw new Error( JCAT.Language.Sentence('错误：正在实例化一个抽象类 %s。','JCAT.JS',null,'"+sClassName+"') ) ;\r\n" ;
	sCode+= "}\r\n" ;

	eval(sCode) ;
}

JCAT.Class.IsAbstractMethod = function (Method)
{
	if( typeof(Method)!='function' )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 Method 必须为类(function); 传入类型为:%s','JCAT.JS',null,typeof(Method))
		) ;
	}
	
	sMethodCode = Method.toString() ;
	return sMethodCode.search(/--this abstract a method--/i)>=0 ;
}

JCAT.Class.AssertConcreteClass = function (sClassName)
{
	if( typeof(sClassName)!='string' )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 sClassName 必须为类名称(字符串); 传入类型为:%s','JCAT.JS',null,typeof(sClassName))
		) ;
	}
	
	eval( 'Class =' + sClassName ) ;
	var nAbstractMethodCount = 0 ;
	var sAbstractMethods = '' ;
	
	// 历遍所有的方法,检查是否存在 抽象方法
	for( var sMemberName in Class.prototype )
	{
		eval('Method = Class.prototype.'+sMemberName) ;
		if( JCAT.Class.IsAbstractMethod(Method) )
		{
			nAbstractMethodCount ++ ;
			
			if(sAbstractMethods)
			{
				sAbstractMethods+= ', ' ;
			}
			sAbstractMethods+= sMemberName ;
		}
	}
	
	if(nAbstractMethodCount)
	{
		throw new Error(
			JCAT.Language.Sentence('抽象类%s 无法实例化; 以下抽象方法尚未实现:%s','JCAT.JS',null,sClassName,sAbstractMethods)
		) ;
	}
}

JCAT.Class.AssertHasImplements = function(aObject,sInterfaceName)
{
	// 检查参数 
	if( typeof(aObject)!='object' )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 aObject 必须为对象.','JCAT.JS',null)
		) ;		
	}
	if( typeof(sInterfaceName)!='string' )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 sInterfaceName 必须有效的接口名称.','JCAT.JS',null)
		) ;		
	}
	
	eval( 'Interface = ' + sInterfaceName ) ;
	if( typeof(Interface)!='function' )
	{
		throw new Error(
			JCAT.Language.Sentence('参数 sInterfaceName 必须有效的接口名称.','JCAT.JS',null,sInterfaceName)
		) ;	
	}
	
	if( !JCAT.Class.HasImplements(aObject,Interface) )
	{
		throw new Error(
			JCAT.Language.Sentence('对象必须实现接口 %s ','JCAT.JS',null)
		) ;			
	}
}

JCAT.Class.HasImplements = function ( ClassOrIns, Interface, bThrowException/*=false*/ )
{
	if( typeof(bThrowException)!='function' )
	{
		bThrowException = false ;
	}
	
	if( typeof(Interface)!='function' )
	{
		throw new Error('Parameter Interface must be a Class(function).') ;
	}
	
	if( typeof(ClassOrIns)=='function' )
	{
		var bClass = true ;
	}
	else if( typeof(ClassOrIns)=='object' )
	{
		var bClass = false ;
	}
	else
	{
		throw new Error('Parameter ClassOrIns must be a Class(function) or a instance.') ;
	}

	for(var InterfaceMemberName in Interface.prototype)
	{
		eval("bIsFunction = (typeof(Interface.prototype."+InterfaceMemberName+")=='function')") ;
		if(!bIsFunction)
		{
			continue ;
		}
		
		// 类
		if( bClass )
		{
			MemberName = 'ClassOrIns.prototype.' + InterfaceMemberName ;
		}
		
		// 对象
		else
		{
			MemberName = 'ClassOrIns.' + InterfaceMemberName ;
		}
		
		eval("bImplementsFunction = (typeof("+MemberName+")=='function')") ;
		if(!bImplementsFunction)
		{
			if(bThrowException)
			{
				throw new Error(
					JCAT.Language.Sentence('Parameter ClassOrIns hasn`t implements Interface method: %s.','JCAT.JS',null,InterfaceMemberName) ) ;
			}
			
			else
			{
				return false ;
			}
		}
	}
	
	return true ;
}

JCAT.Class.Inherit = function ( SubClass, ParentClass, sParentClassConstructrName/*=null*/ )
{
	if( typeof(SubClass)!='function' )
	{
		throw new Error('Parameter SubClass must be a Class(function).') ;
	}
	if( typeof(ParentClass)!='function' )
	{
		throw new Error('Parameter ParentClass must be a Class(function).') ;
	}
	
	// 拷贝父类 的构造函数
	if( typeof(sParentClassConstructrName)=='string' )
	{
		eval("SubClass.prototype."+sParentClassConstructrName+" = ParentClass") ;
	}
	
	// 将 父类 的方法拷贝给 子类
	for(var MemberName in ParentClass.prototype)
	{		
		// 重载
		eval("bMethodExtents = (typeof(SubClass.prototype."+MemberName+")=='function')")
		if(bMethodExtents)
		{
			throw new Error('SubClass has method: '+MemberName+' already, Can not inherit from ParentClass.') ;
		}
		
		// 拷贝
		eval("SubClass.prototype."+MemberName+" = ParentClass.prototype."+MemberName) ;		
	}
}

JCAT.Class.CheckDependClasses = function (arrClasses,sForWhom/*=null*/,bThrowException/*=true*/)
{
	if( typeof(bThrowException)!='function' )
	{
		bThrowException = true ;
	}
	if( typeof(sForWhom)=='undefined' )
	{
		sForWhom = '' ;
	}
	
	for(var nIdx=0; nIdx<arrClasses.length; nIdx++)
	{
		eval( "bExists = (typeof("+arrClasses[nIdx]+")=='function')" )
		if(!bExists)
		{
			if(bThrowException)
			{
				throw new Error(
					JCAT.Language.Sentence('%s 缺少依赖的类 %s 。','JCAT.JS',null
					, sForWhom, arrClasses[nIdx] )) ;
			}
			
			else
			{
				return false ;
			}
		}
	}
}




