<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_AccessRoutePath.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


class JCAT_AccessRoutePath
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sScriptPath
	 * @return	void
	 */
	public function JCAT_AccessRoutePath($sScriptPath='/?')
	{
		$this->sScriptPath = $sScriptPath ;
		
		$arrUrl = parse_url($sScriptPath) ;		
		if( isset($arrUrl['query']) )
		{
			parse_str($arrUrl['query'],$this->arrFixedParameters) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sPrefix=''				string
	 * @param	$sParamName=null		string
	 * @param	$sPostfix=''			string
	 * @return	void
	 */
	public function AddParameter($sPrefix='',$sParamName=self::FIXED_VALUE_PARAM,$sPostfix='',$sMatch='[\w\-_\.%]+')
	{		
		$this->arrParameters[$sParamName] = array(
						'name' => $sParamName
						, 'prefix' => $sPrefix
						, 'postfix' => $sPostfix
						, 'match' => $sMatch
		) ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$sText
	 * @return	void
	 */
	private function EscapeRegexpKeywords($sText)
	{
		$arrKeywords = array('/','|','.','+','-','*','?','(',')','[',']','{','}',',','`','^','$') ;
		foreach ($arrKeywords as $sKeyword)
		{
			$sText = str_replace($sKeyword,'\\'.$sKeyword,$sText) ;
		}
		return $sText ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function MakeKey()
	{
		$arrParamters = array_merge(
				array_keys($this->arrFixedParameters)
				, array_keys($this->arrParameters)
		) ;
		
		// remove fixed value param(定值参数)
		$arrParamters = array_diff($arrParamters,array(self::FIXED_VALUE_PARAM)) ;
		
		$arrPath = parse_url($this->sScriptPath) ;
		
		return self::MakeKeyFromParamNames($arrPath['path'],$arrParamters) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$arrParamNames	array
	 * @static
	 * @return	void
	 */
	static public function MakeKeyFromParamNames($sScriptPath,array $arrParamNames)
	{
		sort($arrParamNames) ;
		return $sScriptPath.'?'.implode(':',$arrParamNames) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function MakePathRegexp()
	{
		$sRegExp = '' ;
		foreach ($this->arrParameters as $arrParam)
		{
			$sPrefix = $this->EscapeRegexpKeywords($arrParam['prefix']) ;
			$sPostfix = $this->EscapeRegexpKeywords($arrParam['postfix']) ;
			
			// fixed value param
			if($arrParam['name']==self::FIXED_VALUE_PARAM)
			{
				$sRegExp.= "{$sPrefix}{$sPostfix}" ;
			}
			
			else 
			{
				$sRegExp.= "{$sPrefix}({$arrParam['match']}){$sPostfix}" ;
			}
		}
		
		return $sRegExp.'\/?' ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function MakePathRewrite($sGroupPrefix='$')
	{
		$sRewritePath = (strstr($this->sScriptPath,'?')===false)? '?': '' ;
		$nParamIndex = 0 ;
		foreach ($this->arrParameters as $arrParam)
		{
			// fixed value param
			if($arrParam['name']!=self::FIXED_VALUE_PARAM)
			{
				$nParamIndex ++ ;
				$sRewritePath.= "&{$arrParam['name']}={$sGroupPrefix}{$nParamIndex}" ;
			}
		}
		
		return $sRewritePath ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sLinePrefix=''		string
	 * @return	string
	 */
	public function MakePathRule($sLinePrefix='')
	{
		$sRewritePath = $this->MakePathRewrite() ;
		$sRegExp = $this->MakePathRegexp() ;
		return "{$sLinePrefix}RewriteRule ^{$sRegExp}$ {$this->sScriptPath}{$sRewritePath}	[QSA]" ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$arrParamDatas		array
	 * @return	void
	 */
	public function RewritePath(array $arrParamDatas)
	{
		$sRewritePath = '' ;
		
		foreach($this->arrParameters as $arrParam)
		{
			// fixed value param
			if($arrParam['name']==self::FIXED_VALUE_PARAM)
			{
				$Value = '' ;
			}
			
			else
			{
				if( !isset($arrParamDatas[$arrParam['name']]) )
				{
					throw new JCAT_Exception(JCAT_Language::SentenceEx(
						'缺少参数 %s'
						, 'JCAT', null
						, $arrParam['name']
					)) ;
				}
				$Value = $arrParamDatas[$arrParam['name']] ;
			}
			
			$sPrefix = $this->EscapeRegexpKeywords($arrParam['prefix']) ;
			$sPostfix = $this->EscapeRegexpKeywords($arrParam['postfix']) ;
			$sRewritePath.= "{$sPrefix}{$Value}{$sPostfix}" ;
		}
		
		return $sRewritePath ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sUrl		string
	 * @return	bool
	 */
	public function Match($sUrl)
	{
		$sPathReg = $this->MakePathRegexp() ;
		$sPathReg = "/^{$sPathReg}$/" ;
		
		return preg_match($sPathReg,$sUrl) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aRequest	JCAT_Request
	 * @return	bool
	 */
	public function ParsePath($sInUrl,JCAT_Request $aRequest)
	{
		$sUrl = $sInUrl ;
		foreach($this->arrParameters as $arrParam)
		{
			$sPrefix = $this->EscapeRegexpKeywords($arrParam['prefix']) ;
			$sPostfix = $this->EscapeRegexpKeywords($arrParam['postfix']) ;
			
			$sRegExp = "/^{$sPrefix}({$arrParam['match']}){$sPostfix}/" ;
			
			$arrRes = array() ;
			if( !preg_match($sRegExp,$sUrl,$arrRes) )
			{
				return false ;
			}
			
			// 截取
			$sUrl = substr($sUrl,strlen($arrRes[0])) ;
			
			// 设置数据
			$aRequest->SetParam($arrParam['name'],$arrRes[1]) ;
		}
		
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sUrl		string
	 * @return	string
	 */
	public function RestorePath($sUrl)
	{
		$aTempRequest = new JCAT_Request(JCAT_Request::TYPE_CUS) ;
		
		return $this->ParsePath($sUrl,$aTempRequest)?
					($this->sScriptPath.$aTempRequest->MakeUrlQuery()): null ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrParameters = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrFixedParameters = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sScriptPath = '/?' ;
	
	// fixed value , 定值参数
	const FIXED_VALUE_PARAM = null ;
}

?>