<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_CommonAuthenticator.php 1645 2009-04-10 07:36:51Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


class JCAT_CommonAuthenticator
	implements JCAT_IAuthorizable
{
	/**
	 * 授权
	 *
	 * @access	public
	 * @param 	$aIDMgr		JCAT_IdentityManager
	 * @return	bool
	 */
	public function Authorize( JCAT_IIdentityManager $aIDMgr)
	{
		$aIter = $aIDMgr->CreateIdentityIterator() ;
		for ( $aIter->First(); !$aIter->IsDone(); $aIter->Next() )
		{
			$aID = $aIter->Current();
			
			if( $this->AuthorizeID($aID) )
			{
				return true ;
			}
		}
		
		return false ;
	}
	
	/**
	 * check a id object
	 *
	 * @access	public
	 * @param 	$aID=null	JCAT_IIdentity
	 * @return	bool
	 */
	public function AuthorizeID( JCAT_IIdentity $aID )
	{
		// 通过身份认真
		if( $this->nAuthorizeType&self::byIdentity )
		{
			// 禁止 优先
			if( $this->GetPrevious()==self::PREVIOUS_DENY )
			{
				// 明令禁止
				if( $this->IsDenied($aID) )
				{
					return false ;
				}
			}
	
			// 是否允许
			if(!$this->IsAllowed($aID))
			{
				return false ;
			}
		}
		
		// 通过权限人证
		if( $this->nAuthorizeType&self::byPurview )
		{
			if(!$this->AuthorizePurview($aID))
			{
				return false ;
			}
		}
		
		
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function AuthorizePurview(JCAT_IIdentity $aID)
	{
		foreach($this->arrPurviews as $sPurviewDomain=>$nPurview)
		{
			if( !$aID->HasPurview($nPurview,$sPurviewDomain) )
			{
				return false ;
			}
		}
		
		return true ;
	}
	
	/**
	 * 设置认证方式
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function SetAuthorizeType($nType)
	{
		$this->nAuthorizeType = $nType ;
	}
	
	/**
	 * 检查一个身份对象是否被允许授权
	 *
	 * @access	public
	 * @param 	$aID=null	JCAT_IIdentity
	 * @return	bool
	 */
	public function IsAllowed( JCAT_IIdentity $aID=null)
	{
		$sIdentityClass = $aID->GetIdentityClass() ;
		return in_array($sIdentityClass,$this->arrWhiteList) ;
	}
	
	/**
	 * 检查一个身份对象是否被禁止授权
	 *
	 * @access	public
	 * @param 	$aID=null	JCAT_IIdentity
	 * @return	bool
	 */
	public function IsDenied( JCAT_IIdentity $aID=null)
	{
		$sIdentityClass = $aID->GetIdentityClass() ;
		return in_array($sIdentityClass,$this->arrBlackList) ;
	}
	
	/**
	 * 设置一个允许的ID Class
	 *
	 * @access	public
	 * @param	$sIdentityClass	string
	 * @return	void
	 */
	public function AddAllowIdentity($sIdentityClass)
	{
		if( !isset($this->arrWhiteList[$sIdentityClass]) )
		{
			$this->arrWhiteList[$sIdentityClass] = $sIdentityClass ;
		}
	}
	
	/**
	 * 移除一个允许的ID Class
	 *
	 * @access	public
	 * @param	$sIdentityClass	string
	 * @return	void
	 */
	public function RemoveAllowIdentity($sIdentityClass)
	{
		unset($this->arrWhiteList[$sIdentityClass]) ;		
	}
	
	/**
	 * 移除一个禁止的ID Class
	 *
	 * @access	public
	 * @param	$sIdentityClass	string
	 * @return	void
	 */
	public function AddDenyIdentity($sIdentityClass)
	{
		if( !isset($this->arrBlackList[$sIdentityClass]) )
		{
			$this->arrBlackList[$sIdentityClass] = $sIdentityClass ;
		}
	}
	
	/**
	 * 移除一个禁止的ID Class
	 *
	 * @access	public
	 * @param	$sIdentityClass	string
	 * @return	void
	 */
	public function RemoveDenyIdentity($sIdentityClass)
	{
		unset($this->arrBlackList[$sIdentityClass]) ;
	}
	
	/**
	 * 设置优先顺序
	 *
	 * @access	public
	 * @param	$nPrevious	int
	 * @return	old_value
	 */
	public function SetPrevious($nPrevious)
	{
		JCAT_ASSERT::ASSERT_(in_array($nPrevious,array(self::PREVIOUS_ALLOW,self::PREVIOUS_DENY))
				, JCAT_Language::SentenceEx('参数 $nPrevious 无效。','JCAT',null))  ;

		$old_value = $this->nPrevious ;
		$this->nPrevious = $nPrevious ;
		return $old_value ;
	}
	
	/**
	 * 取得优先顺序
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPrevious()
	{
		return $this->nPrevious ;
	}

	/**
	 * 设置权限
	 *
	 * @access	public
	 * @param	$nPurview					int
	 * @param	$sPurviewDomain=null		string
	 * @return	void
	 */
	public function AddPurview($nPurview,$sPurviewDomain=null)
	{
		$this->arrPurviews[$sPurviewDomain] = $nPurview ;
	}
	
	
	const PREVIOUS_ALLOW = 1 ;

	const PREVIOUS_DENY = 2 ;

	/**
	 * 允许顺序
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nPrevious = self::PREVIOUS_DENY ;
	
	/**
	 * 白名单
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrWhiteList = array('anybody'=>'anybody') ;

	/**
	 * 黑名单
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrBlackList = array() ;

	private $arrPurviews = array() ;
	
	const byIdentity = 1 ;
	
	const byPurview = 2 ;
	
	private $nAuthorizeType = 3 ;
}

?>