<?php

/**
 * 身份类, 该类仅仅用来表示任何人
 */
class JCAT_IdentityAnybody extends JCAT_Model 
		implements JCAT_IIdentity 
{
	/**
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_IdentityAnybody()
	{
		$this->JCAT_Model(__CLASS__) ;
	}
	
	/**
	 * 主要用于会话恢复时
	 * 
	 * @access	public
	 * @return	void
	 */
	public function __wakeup(){}
	
	/**
	 * 取得身份类型
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetIdentityClass()
	{
		return 'anybody' ;
	}
	
	/**
	 * 用户注册
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Register(){return true;}
	
	/**
	 * 用户注销
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Unregister(){return true;}

	
	/**
	 * 修改用户信息
	 * 
	 * @access	public
	 * @param	$arrDataNamesForModify=array()		array		被修改的指定数据名称,如果为空则修改所有数据
	 * @return	bool
	 */
	public function ModifyUserInfomation( array $arrDataNamesForModify=array() ){return true;}
	
	/**
	 * 登录
	 * 
	 * @access	public 
	 * @param $sAuthName			string					认证用户名 
	 * @param $sAuthPassword		string					认证用户密码 
	 * @param $aIDMgr=null			JCAT_IdentityManager
	 * @param $bSendMessage=true	bool					是否发送消息 
	 * @return bool 
	 */
	public function Login ( $sAuthName, $sAuthPassword, JCAT_IdentityManager $aIDMgr=null, $bSendMessage=true )
	{return true;}
	
	/**
	 * 登出
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Logout(){return true;}
	
	/**
	 * 加查是否已登录
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsLogined(){return true;}
	
	
	/**
	 * 检查权限
	 * 
	 * @access	public
	 * @param	$nPurviewBit		int			权限位
	 * @param	$sPurviewName=null	string		指定权限名称
	 * @return	bool
	 */
	public function HasPurview($nPurviewBit,$sPurviewName=null){return false;}
	
	
	/**
	 * 设置最新的活动时间
	 * 
	 * @access	public
	 * @return	int
	 */
	public function Active(){return true;}
	
	
	/**
	 * 设置会话对象
	 * 
	 * @access	public
	 * @param	$aSession	JCAT_ISession	会话
	 * @return	old_value
	 */
	public function SetSession(JCAT_ISession $aSession){return null;}
	
	/**
	 * 取得会话对象
	 * 
	 * @access	public
	 * @return	JCAT_ISession
	 */
	public function GetSession(){return null;}
	
	/**
	 * 设置最新的活动时间
	 * 
	 * @access	public
	 * @param 	$nAuthID		int		认证用户ID
	 * @param 	$sSessionKey	string	认证用户会话名
	 * @return	int
	 */
	public function LoadFromSession($nAuthID,$sSessionKey){return time();}

	
	/**
	 * 设置密码加密方式
	 * 
	 * @access	public
	 * @param	$Encryption=JCAT_Authentication::MD5_PASSWORD		callback	加密函数
	 * @return	void
	 */
	public function SetEncryption( $Encryption=JCAT_Authentication::PASSWORD_MD5 ){}
	
	/**
	 * 取得密码加密方式
	 * 
	 * @access	public
	 * @return	callback
	 */
	public function GetEncryption(){return JCAT_Authentication::PASSWORD_PLAIN;}
	
	/**
	 * 取得认证用户名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetAuthName(){return 'anybody';}
	
	/**
	 * 取得认证密码（加密过的密文）
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetAuthPassword(){return '';}
	
	/**
	 * 取得帐号创建时间
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetCreateTime(){return 0;}
	
	/**
	 * 取得最近登录时间
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetLastLoginTime(){return 0;}
	
	/**
	 * 取得最近登录IP
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetLastLoginIP(){return '0.0.0.0';}
	
	/**
	 * 取得最近活动时间
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetActiveTime(){return time();}
	
	

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Load(  ) {}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Save(  ) {}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Create() {}
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Delete() {}

	/**
	 * 模型是否存在
	 * 
	 * @access	public
	 * @param	$bRequery=false		bool	对于高级模型（如数据库模型），查询 模型是否存在 会存在一定性能代价 ，该参数允许缓存查询结果
	 * @return	bool
	 */
	public function IsExists( $bRequery=false ) {return true ;}
}

?>
