<?php

/**
 * 身份管理器
 *
 */
class JCAT_IdentityManager implements JCAT_IIdentityManager
{
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_IdentityManager
	 */
	static public function GetGlobalInstance()
	{		
		if( !self::$aGlobalInstance )
		{
			$aSession = JCAT_Session::GetGlobalInstance() ;
			self::$aGlobalInstance = self::CreateInstance(self::DEFAULT_IDMGR_NAME,$aSession) ;	
		}
		
		return self::$aGlobalInstance ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aGlobalInstance	JCAT_IdentityManager
	 * @return	void
	 */
	public function SetGlobalInstance(JCAT_IdentityManager $aGlobalInstance)
	{
		self::$aGlobalInstance = $aGlobalInstance ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sInsName			string
	 * @param	$aSession=null		JCAT_ISession
	 * @static
	 * @return	void
	 */
	static public function CreateInstance($sInsName,JCAT_ISession $aSession=null)
	{
		$sIDSessionKey = self::IDMGR_SESSIONKEY_PREFIX.$sInsName ;
		
		// create a php session
		if(!$aSession)
		{
			$aSession = JCAT_Session::GetGlobalInstance() ;
		}
		
		// try get from session
		$aIDMgr = $aSession->GetVariable($sIDSessionKey) ;

		return $aIDMgr?
			$aIDMgr :											// restore object from session
			new JCAT_IdentityManager($sInsName, $aSession) ;	// create new object
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$sInsName			string
	 * @param	$aSession=null		JCAT_ISession
	 * @return	void
	 */
	protected function JCAT_IdentityManager($sInsName,JCAT_ISession $aSession=null)
	{
		// session
		if(!$aSession)
		{
			$aSession = JCAT_Session::GetGlobalInstance() ;
		}
		$this->SetSession($aSession) ;

		$this->sInsName = $sInsName ;
		
		// save to Session
		$this->sSessionKey = self::IDMGR_SESSIONKEY_PREFIX.$sInsName ;
		$this->SaveSession() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function SaveSession()
	{
		$aSession = $this->GetSession() ;
		$aSession->SetVariable($this->sSessionKey,$this) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetName()
	{
		return $this->sInsName ;		
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function __sleep()
	{
		$arrParentPropertys[] = JCAT_Package::MakePrivatePropertyNameForSerialize('sSessionKey',__CLASS__) ;
		$arrParentPropertys[] = JCAT_Package::MakePrivatePropertyNameForSerialize('arrLoginedIdentitys',__CLASS__) ;
		
		return $arrParentPropertys ;
	}
	
	/**
	 * 通过身份名称取得身份
	 * 
	 * @access	public
	 * @param	$sIdentityName		string	身份名称
	 * @return	JCAT_IIdentity
	 */
	public function QueryIdentity($sIdentityName)
	{
		return isset($this->arrLoginedIdentitys[$sIdentityName])?
					$this->arrLoginedIdentitys[$sIdentityName]:
					null ;
	}

	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$aIdentity		JCAT_IIdentity		what's this
	 * @return	old_value
	 */
	public function IdentityLogin(JCAT_IIdentity $aIdentity)
	{
		$sIdentityName = $aIdentity->GetIdentityClass() ;
		
		if(!$aIdentity->IsLogined())
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'身份：“%s”尚未完成登录，无法提交到身份管理器。'
				, 'JCAT', null
				, $sIdentityName
			)) ;
		}

		// 已经存在的 身份
		if(isset($this->arrLoginedIdentitys[$sIdentityName]))
		{
			$old_value = $this->arrLoginedIdentitys[$sIdentityName] ;
			
			// 已存在 先登出
			$old_value->Logout() ;
		}
		else 
		{
			$old_value = null ;
		}
		
		$this->arrLoginedIdentitys[$sIdentityName] = $aIdentity ;
		return $old_value ;
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$IdentityOrName		JCAT_IIdentity, string		what's this
	 * @return	void
	 */
	public function IdentityLogout( $IdentityOrName )
	{
		JCAT_ASSERT::ASSERT_ISTHESE($IdentityOrName,array('string','JCAT_IIdentity'));
		
		if( JCAT_Global::HasImplementedTo($IdentityOrName,'JCAT_IIdentity') )
		{
			$sIdentityName = $IdentityOrName->GetIdentityClass() ;
		}
		else
		{
			$sIdentityName =& $IdentityOrName ;
			if(isset($this->arrLoginedIdentitys[$sIdentityName]))
			{
				$this->arrLoginedIdentitys[$sIdentityName]->Logout() ;
			}
		}
		
		unset( $this->arrLoginedIdentitys[$sIdentityName] ) ;
	}
	
	/**
	 * 为所有已登录的 身份对象 创建一个迭代器
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateIdentityIterator()
	{
		return new JCAT_ArrayIterator($this->arrLoginedIdentitys) ;
	}

	/**
	 * 设置会话对象
	 * 
	 * @access	public
	 * @param	$aSession	JCAT_ISession	会话
	 * @return	old_value
	 * @see JCAT_IIdentity::SetSession()
	 */
	public function SetSession(JCAT_ISession $aSession)
	{		
		$old_value = $this->aSession ;
		$this->aSession = $aSession ;
		return $old_value ;
	}

	
	/**
	 * 取得会话对象
	 * 
	 * @access	public
	 * @return	JCAT_ISession
	 * @see JCAT_IIdentity::GetSession()
	 */
	public function GetSession()
	{
		return $this->aSession ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetSessionKey()
	{
		return $this->sSessionKey ;
	}
	
	// 属性 ////////////////////////////////////
	
	
	const DEFAULT_IDMGR_NAME = '@Default@' ;
	
	const IDMGR_SESSIONKEY_PREFIX = '__IDManger::' ;
	
	/**
	 * 已登录的身份
	 * 
	 * @access	private
	 * @var		array:JCAT_IIdentity
	 * @static 
	 */
	private $arrLoginedIdentitys = array() ;
	
	/**
	 * 用于保存身份的会话类类名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $aSession ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sSessionKey ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sInsName ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array:JCAT_IdentityManager
	 */
	static private $aGlobalInstance ;
}

?>