<?php

/**
 * 身份类接口
 */
interface JCAT_IIdentity
{	
	/**
	 * 取得身份类型
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetIdentityClass() ;

	/**
	 * 登录
	 * 
	 * @access	public 
	 * @param $sAuthName			string					认证用户名 
	 * @param $sAuthPassword		string					认证用户密码 
	 * @param $aIDMgr=null			JCAT_IdentityManager
	 * @param $bSendMessage=true	bool					是否发送消息 
	 * @return bool 
	 */
	public function Login ( $sAuthName, $sAuthPassword, JCAT_IdentityManager $aIDMgr=null, $bSendMessage=true ) ;

	/**
	 * 登出
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Logout() ;
	
	/**
	 * 加查是否已登录
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsLogined() ;
	
	
	/**
	 * 检查权限
	 * 
	 * @access	public
	 * @param	$nPurviewBit			int			权限位
	 * @param	$sPurviewDomain=null	string		指定权限域
	 * @return	bool
	 */
	public function HasPurview($nPurviewBit,$sPurviewDomain=null) ;
	
	
	/**
	 * 设置最新的活动时间
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Activing() ;
	
	
	/**
	 * 设置密码加密方式
	 * 
	 * @access	public
	 * @param	$Encryption=JCAT_Authentication::MD5_PASSWORD		callback	加密函数
	 * @return	void
	 */
	public function SetEncryption( $Encryption=JCAT_Authentication::PASSWORD_MD5 ) ;
	
	/**
	 * 取得密码加密方式
	 * 
	 * @access	public
	 * @return	callback
	 */
	public function GetEncryption() ;
	
	/**
	 * 对密码进行加密
	 *
	 * @access	public
	 * @param	$sPassword
	 * @return	string
	 */
	public function EncodePassword($sPassword) ;
	
	/**
	 * 取得认证用户名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetAuthName() ;
	
	/**
	 * 取得认证密码（加密过的密文）
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetAuthPassword() ;
	
	/**
	 * 取得帐号创建时间
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetCreateTime() ;
	
	/**
	 * 取得最近登录时间
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetLastLoginTime() ;
	
	/**
	 * 取得最近活动时间
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetActiveTime() ;
	
	/**
	 * 取得最近登录IP
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetLastLoginIP() ;
	
	/**
	 * 取得活动IP
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetActiveIP() ;
	
}

?>
