<?php

/**
 * 身份管理器
 *
 */
interface JCAT_IIdentityManager
{
	/**
	 * 通过身份名称取得身份
	 * 
	 * @access	public
	 * @param	$sIdentityName		string	身份名称
	 * @return	JCAT_IIdentity
	 */
	public function QueryIdentity($sIdentityName) ;

	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$aIdentity		JCAT_IIdentity		what's this
	 * @return	old_value
	 */
	public function IdentityLogin(JCAT_IIdentity $aIdentity) ;
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$IdentityOrName		JCAT_IIdentity, string		what's this
	 * @return	void
	 */
	public function IdentityLogout( $IdentityOrName ) ;
	
	/**
	 * 为所有已登录的 身份对象 创建一个迭代器
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateIdentityIterator() ;

	/**
	 * 设置会话对象
	 * 
	 * @access	public
	 * @param	$aSession	JCAT_ISession	会话
	 * @return	old_value
	 * @see JCAT_IIdentity::SetSession()
	 */
	public function SetSession(JCAT_ISession $aSession) ;
	
	/**
	 * 取得会话对象
	 * 
	 * @access	public
	 * @return	JCAT_ISession
	 * @see JCAT_IIdentity::GetSession()
	 */
	public function GetSession() ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetSessionKey() ;
	
}

?>
