<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_FSPackageFSOIterator extends JCAT_ArrayIterator 
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_FSPackageFSOIterator( $nIterFlag=JCAT_FSPackage::ITER_DEFAULT )
	{
		$this->SetIterFlag($nIterFlag) ;
	}
	
	/**
	 * 设置对象属性 self::$nIterFlag
	 *
	 * @access	public
	 * @param	$nIterFlag		int	迭代方式
	 * @return	void
	 */
	public function SetIterFlag($nIterFlag)
	{
		$this->nIterFlag = $nIterFlag ;
	}
	
	/**
	 * 取得对象属性 self::$nIterFlag
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetIterFlag()
	{
		return $this->nIterFlag ;
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$arrFSOs	array
	 * @return	void
	 */
	public function AddFSOs(array $arrFSOs)
	{
		$arrArrayRef =& $this->GetArrayRef() ;
		if(!$arrArrayRef)
		{
			$arrArrayRef = array() ;
		}
		$arrArrayRef = array_merge($arrArrayRef,$arrFSOs) ;
	}
	
	
	
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$sFunction
	 * @return	void
	 */
	protected function ReturnType($sFunction)
	{
		$aFSO = parent::$sFunction() ;
		
		$sIterFlg = $this->GetIterFlag() ;
		if($sIterFlg&JCAT_FSPackage::ITER_RET_FSO)
		{
			return $aFSO ;
		}
		
		else
		{
			$sPath = $aFSO->GetPath() ;
			$sDirName = dirname($sPath) ;
			$sFilename = basename($sPath) ;
			
			$sRet = '' ;
			
			if( $sIterFlg&JCAT_FSPackage::ITER_RET_DIR )
			{
				$sRet.= $sDirName.'/' ;
			}
		
			if( $sIterFlg&JCAT_FSPackage::ITER_RET_FILENAME )
			{
				$sRet.= $sFilename ;
			}
			
			return $sRet ;
		}
	}


	/**
	 * 返回第一项，迭代开始
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function First()
	{ return $this->ReturnType('First') ; }



	/**
	 * 迭代之下一个
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Next()
	{ return $this->ReturnType('Next') ; }



	/**
	 * 返回当前内容
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Current()
	{ return $this->ReturnType('Current') ; }



	/**
	 * 迭代 退至前一个，如果超过第一个，迭代终止
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Previous()
	{ return $this->ReturnType('Previous') ; }



	/**
	 * 返回最后一项，迭代终止
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Last()
	{ return $this->ReturnType('Last') ; }
	
	
	
	///////////////////////////////////////////////////////////////
	
	/**
	 * 对象属性 迭代方式
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nIterFlag ;
}

?>