<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_FSPackage.php 1929 2009-07-08 15:37:00Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

/**
 * 用于文件系统打包
 *
 */
class JCAT_FSPackageOperatorBase
{
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_FSPackageOperatorBase()
	{
		$this->aRootFolder = new JCAT_FSPackageFolder() ;
		$this->aRootFolder->SetName('/') ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sPkgPath
	 * @static
	 * @return	array
	 */
	static public function MakePkgPath($sPkgPath)
	{
		$sTidyPkgPath = preg_replace('/(\/$)|(^\/)/','',$sPkgPath) ;
		$sTidyPkgPath = preg_replace('|\/+|','/',$sTidyPkgPath) ;
		
		return explode('/',$sTidyPkgPath) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sSubFolder='/'					string
	 * @param	$nIterFlg=self::ITER_DEFAULT	int
	 * @return	JCAT_IIterator
	 */
	public function CreateIterator($sSubFolder='/',$nIterFlg=self::ITER_DEFAULT)
	{
		$aParentFolder = ($sSubFolder=='/')? $this->aRootFolder:
			$this->aRootFolder->GetChildRecursion(self::MakePkgPath($sSubFolder)) ;
		
		if( !$aParentFolder or !($aParentFolder instanceof JCAT_FSPackageFolder) )
		{
			return null ;
		}
		
		$aIterator = new JCAT_FSPackageFSOIterator($nIterFlg) ;
		$aParentFolder->SetupIterator($aIterator) ;
		
		return $aIterator ;
	}

	
	
	/**
	 * 设置扩展信息
	 *
	 * @access	public
	 * @param	$sExtName		string		扩展信息名称
	 * @param	$sInfo			string		xml结构的扩展信息
	 * @return	void
	 */
	public function SetExtensionalInfo($sExtName,$sInfo)
	{		
		$sExtName = strtolower($sExtName) ;
		$this->arrExtensionalInfo[$sExtName] = $sInfo ;
	}
	
	/**
	 * 取得扩展信息
	 *
	 * @access	public
	 * @param	$sExtName		string
	 * @return	SimpleXMLElement
	 */
	public function GetExtensionalInfo($sExtName)
	{
		$sExtName = strtolower($sExtName) ;
		return isset($this->arrExtensionalInfo[$sExtName])?
				$this->arrExtensionalInfo[$sExtName]: null ;
	}
	
	/**
	 * 取得所有的扩展信息
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetExtensionalInfoNames()
	{
		return array_keys($this->arrExtensionalInfo) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function CheckZLib()
	{
		if( !function_exists('gzcompress') )
		{
			throw new JCAT_Exception("正在进行的文件包操作，需要 PHP ZLib 模块；当前PHP运行环境没有安装 PHP ZLib 模块。") ;
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * Description
	 * 
	 * @access	protected
	 * @var		JCAT_FSPackageFolder
	 */
	protected $aRootFolder ;
	
	/**
	 * Description
	 * 
	 * @access	protected
	 * @var		array
	 */
	protected $arrExtensionalInfo = array() ;
}

?>