<?php 
/*-- Project Introduce --*/


class JCAT_JPDRBrowser extends JCAT_JPDRCommander 
{	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_JPDRBrowser($bCreateVisible=true)
	{
		try{
			$aCOM = new COM("JPDRWinCmd.Browser") ;
		}
		catch (Exception $e)
		{
			throw new JCAT_Exception( JCAT::CharsetToProject($e->getMessage())) ;
		}
	
		$this->JCAT_JPDRCommander($aCOM) ;
		$aCOM->Create($bCreateVisible) ;
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function WaitingForDocumentComplate()
	{
		while( $this->GetBusy() )
		{
			usleep(200000) ; // 0.2
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetHtmlBody()
	{
		$this->CheckAvailable() ;
		return $this->ExecuteScript('document.body.outerHTML') ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Input		string,array	input的id，或  form name,input name 组成的数组
	 * @return	void
	 */
	public function SetInputValue($Input,$sValue)
	{
		if( is_array($Input) )
		{
			list($sFormName,$sInputName) = $Input ;
			$sGetInput = "document.{$sFormName}.{$sInputName}" ; 
		}
		
		else
		{
			$sGetInput = "document.getElementById('{$Input}')" ; 
		}
		
		$sValue = addslashes($sValue) ;
		$sScript = "{$sGetInput}.value=\"{$sValue}\"" ;
		
		$this->ExecuteScript("{$sGetInput}.focus()") ;
		$this->ExecuteScript($sScript) ;
		$this->ExecuteScript("{$sGetInput}.blur()") ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Input				string,array	input的id，或  form name,input name 组成的数组
	 * @param	$bChecked=true
	 * @return	void
	 */
	public function SetChecked($Input,$bChecked=true)
	{
		if( is_array($Input) )
		{
			list($sFormName,$sInputName) = $Input ;
			$sGetInput = "document.{$sFormName}.{$sInputName}" ; 
		}
		
		else
		{
			$sGetInput = "document.getElementById('{$Input}')" ; 
		}
		
		if($bChecked)
		{
			$this->ExecuteScript("{$sGetInput}.click()") ;
			$this->ExecuteScript("{$sGetInput}.focus()") ;
		}
		
		else 
		{
			$this->ExecuteScript("{$sGetInput}.checked=false") ;
			$this->ExecuteScript("{$sGetInput}.blur()") ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Select				string,array	input的id，或  form name,select name 组成的数组
	 * @param	$nOptionIndex		int				可以用负数表示倒数
	 * @return	void
	 */
	public function SetSelected($Select,$nOptionIndex)
	{
		if( is_array($Select) )
		{
			list($sFormName,$sSelectName) = $Select ;
			$sGetSelect = "document.{$sFormName}.{$sSelectName}" ; 
		}
		
		else
		{
			$sGetSelect = "document.getElementById('{$Select}')" ; 
		}
		
		$nSelectedOption = ($nOptionIndex<0)? "{$sGetSelect}.options.length{$nOptionIndex}": $nOptionIndex ;
		$this->ExecuteScript("{$sGetSelect}.focus()") ;
		$this->ExecuteScript("{$sGetSelect}.options.selectedIndex = {$nSelectedOption}") ;
	
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sElementId
	 * @return	void
	 */
	public function SetElementFocus($sElementId,$bFocus=true)
	{
		$this->ExecuteScript(
			sprintf("document.getElementById('{$sElementId}').%s()",($bFocus?'focus':'blur'))
		) ;
	}

	
	////////////////////////////////////////////////////

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function Navigate($sUrl,$Flags=null,$TargetFrameName=null,$PostData=null,$Headers=null)
	{
		$this->GetCOM()->Navigate($sUrl,$Flags,$TargetFrameName,$PostData,$Headers) ;
	}
	
	public function ExecuteScript($sJSCode,$bThrow=false)
	{
		try{
			return $this->GetCOM()->ExecuteScript($sJSCode) ;
		}
		
		catch(com_exception $e)
		{
			$sMessage = JCAT::CharsetToProject($e->getMessage()) ;
			$nCode = $e->getCode() ;
			$sMessage = "在浏览器中执行一段 javascript 代码时遇到了错误：{$sMessage}({$nCode})。\r\n\r\n正在执行的代码为：\r\n{$sJSCode}" ;
			
			if($bThrow)
			{
				new JCAT_Exception($sMessage,$nCode) ;
			}
			
			else
			{
				JCAT_Gtk::MessageDialog($sMessage) ;
			}
		}
	}

	public function GetElement()
	{ return $this->GetCOM()->GetElement() ; }
	public function SetElement($Value)
	{ $this->GetCOM()->SetElement($Value) ; }

	public function GoBack()
	{ return $this->GetCOM()->GoBack() ; }
	public function GoForward()
	{ return $this->GetCOM()->GoForward() ; }
	public function GoHome()
	{ return $this->GetCOM()->GoHome() ; }
	public function GoSearch()
	{ return $this->GetCOM()->GoSearch() ; }
	public function Quit()
	{ return $this->GetCOM()->Quit() ; }
	public function Stop()
	{ return $this->GetCOM()->Stop() ; }
	public function Refresh()
	{ return $this->GetCOM()->Refresh() ; }

	// property AddressBar
	public function GetAddressBar()
	{ return $this->GetCOM()->GetAddressBar() ; }
	public function SetAddressBar($Value)
	{ $this->GetCOM()->SetAddressBar($Value) ; }

	// property FullScreen
	public function GetFullScreen()
	{ return $this->GetCOM()->GetFullScreen() ; }
	public function SetFullScreen($Value)
	{ $this->GetCOM()->SetFullScreen($Value) ; }

	// read-only property
	public function GetApplication()
	{ return $this->GetCOM()->GetApplication() ; }
	public function GetBusy()
	{ return $this->GetCOM()->GetBusy() ; }
	public function GetFullName()
	{ return $this->GetCOM()->GetFullName() ; }
	public function GetHWND()
	{ return $this->GetCOM()->GetHWND() ; }
	public function GetLocationName()
	{ return $this->GetCOM()->GetLocationName() ; }
	public function GetLocationURL()
	{ return $this->GetCOM()->GetLocationURL() ; }
	public function GetParent()
	{ return $this->GetCOM()->GetParent() ; }
	public function GetPath()
	{ return $this->GetCOM()->GetPath() ; }
	public function GetReadyState()
	{ return $this->GetCOM()->GetReadyState() ; }
	public function GetTopLevelContainer()
	{ return $this->GetCOM()->GetTopLevelContainer() ; }
	public function GetType()
	{ return $this->GetCOM()->GetType() ; }
	

	// read/write property
	public function GetHeight()
	{ return $this->GetCOM()->GetHeight() ; }
	public function SetHeight($Value)
	{ $this->GetCOM()->SetHeight($Value) ; }

	public function GetLeft()
	{ return $this->GetCOM()->GetLeft() ; }
	public function SetLeft($Value)
	{ $this->GetCOM()->SetLeft($Value) ; }

	public function GetMenuBar()
	{ return $this->GetCOM()->GetMenuBar() ; }
	public function SetMenuBar($Value)
	{ $this->GetCOM()->SetMenuBar($Value) ; }

	public function GetName()
	{ return $this->GetCOM()->GetName() ; }
	public function SetName($Value)
	{ $this->GetCOM()->SetName($Value) ; }

	public function GetOffline()
	{ return $this->GetCOM()->GetOffline() ; }
	public function SetOffline($Value)
	{ $this->GetCOM()->SetOffline($Value) ; }

	public function GetRegisterAsBrowser()
	{ return $this->GetCOM()->GetRegisterAsBrowser() ; }
	public function SetRegisterAsBrowser($Value)
	{ $this->GetCOM()->SetRegisterAsBrowser($Value) ; }

	public function GetRegisterAsDropTarget()
	{ return $this->GetCOM()->GetRegisterAsDropTarget() ; }
	public function SetRegisterAsDropTarget($Value)
	{ $this->GetCOM()->SetRegisterAsDropTarget($Value) ; }

	public function GetResizable()
	{ return $this->GetCOM()->GetResizable() ; }
	public function SetResizable($Value)
	{ $this->GetCOM()->SetResizable($Value) ; }

	public function GetSilent()
	{ return $this->GetCOM()->GetSilent() ; }
	public function SetSilent($Value)
	{ $this->GetCOM()->SetSilent($Value) ; }

	public function GetStatusBar()
	{ return $this->GetCOM()->GetStatusBar() ; }
	public function SetStatusBar($Value)
	{ $this->GetCOM()->SetStatusBar($Value) ; }

	public function GetStatusText()
	{ return $this->GetCOM()->GetStatusText() ; }
	public function SetStatusText($Value)
	{ $this->GetCOM()->SetStatusText($Value) ; }

	public function GetTheaterMode()
	{ return $this->GetCOM()->GetTheaterMode() ; }
	public function SetTheaterMode($Value)
	{ $this->GetCOM()->SetTheaterMode($Value) ; }

	public function GetToolBar()
	{ return $this->GetCOM()->GetToolBar() ; }
	public function SetToolBar($Value)
	{ $this->GetCOM()->SetToolBar($Value) ; }

	public function GetTop()
	{ return $this->GetCOM()->GetTop() ; }
	public function SetTop($Value)
	{ $this->GetCOM()->SetTop($Value) ; }

	public function GetVisible()
	{ return $this->GetCOM()->GetVisible() ; }
	public function SetVisible($Value)
	{ $this->GetCOM()->SetVisible($Value) ; }

	public function GetWidth()
	{ return $this->GetCOM()->GetWidth() ; }
	public function SetWidth($Value)
	{ $this->GetCOM()->SetWidth($Value) ; }

}

?>