<?php 
/*-- Project Introduce --*/


class JCAT_JPDRClipboard extends JCAT_JPDRCommander 
{
	const CF_TEXT = 1 ;
	const CF_BITMAP = 2 ;
	const CF_UNICODETEXT = 13 ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_JPDRClipboard()
	{
		try{
			$this->JCAT_JPDRCommander(new COM("JPDRWinCmd.Clipbd")) ;
		}
		catch (Exception $e)
		{
			throw new JCAT_Exception( JCAT::CharsetToProject($e->getMessage())) ;
		}
	}
		
	/**
	 * 
	 *
	 * @access	public
	 * @param	$sFormat		string
	 * @return	int
	 */
	public function MakeFormat($sFormat)
	{
		$this->CheckAvailable() ;
		
		$nFormatId = 0 ;
		$this->GetCOM()->MakeFormat($sFormat,$nFormatId) ;
		return $nFormatId ;
	}

	/**
	 * 
	 *
	 * @access	public
	 * @param	$nFormat		int
	 * @return	string
	 */
	public function Get($nFormat=self::CF_UNICODETEXT)
	{
		$this->CheckAvailable() ;
		
		$sData = '' ;
		$nDataLen = 0 ;
		$this->GetCOM()->Get($nFormat,$sData,$nDataLen) ;
		return $sData ;
	}

	/**
	 * 
	 *
	 * @access	public
	 * @param	$nFormat		int
	 * @param	$sData		int
	 * @return	void
	 */
	public function Set($sData,$nFormat=self::CF_UNICODETEXT)
	{
		$this->CheckAvailable() ;
		
		// 计算将 多字节字符串 转换到 Unicode 字符串的长度
		$nDataUnicodeStringLen = 0 ;
		$nInByteLength=strlen($sData);
		for($nByteIdx=0;$nByteIdx<$nInByteLength;)
		{
			$nByteIdx+= ord(substr($sData,$nByteIdx,1))>127? 2: 1 ;
			$nDataUnicodeStringLen+= 2 ;
		}
		
		// unicode 字符串的长度必须算上字符串末尾的空字符 '\0'
		$nDataUnicodeStringLen+= 2 ;
		
		$this->GetCOM()->Set($nFormat,$sData,$nDataUnicodeStringLen) ;
	}

	/**
	 * 
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetAllFormat()
	{
		$this->CheckAvailable() ;
		
		$sFormats = '' ;
		$this->GetCOM()->GetAllFormat($sFormats) ;
		return explode(',',$sFormats) ;
	}
		
}
?>