<?php 
/*-- Project Introduce --*/


class JCAT_JPDRDialog extends JCAT_JPDRCommander 
{	
	const DLG_BROWSER = 1 ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_JPDRDialog()
	{
		try{
			$this->JCAT_JPDRCommander(new COM("JPDRWinCmd.Dialog")) ;
		}
		catch (Exception $e)
		{
			throw new JCAT_Exception( JCAT::CharsetToProject($e->getMessage())) ;
		}
	}

	/**
	 * 创建一个对话框, 返回这个对话框的窗口句柄
	 *
	 * @access	public
	 * @param	$nType=self::DLG_BROWSER		int
	 * @return	int
	 */
	public function Create($nType=self::DLG_BROWSER)
	{
		$this->CheckAvailable() ;
		
		$nWnd = 0 ;
		$this->GetCOM()->Create($nType,$nWnd) ;
		return $nWnd ;
	}

	/**
	 * 返回对话框类型
	 *
	 * @access	public
	 * @param	$nWnd		int
	 * @return	int
	 */
	public function GetDialogType($nWnd)
	{
		$this->CheckAvailable() ;
		
		$nType = 0 ;
		$this->GetCOM()->GetDialogType($nWnd,$nType) ;
		return $nType ;
	}

	/**
	 * 创建一个浏览器窗口
	 *
	 * @access	public
	 * @return	JCAT_JPDRDialogBrowser
	 */
	public function CreateBrowser()
	{
		return new JCAT_JPDRDialogBrowser($this,$this->Create(self::DLG_BROWSER))  ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$nWnd	int
	 * @return	bool
	 */
	public function Destroy($nWnd)
	{
		$this->CheckAvailable() ;
		
		$bRes = false ;
		$this->GetCOM()->Destroy($nWnd,$bRes) ;
		return $bRes ;
	}
}
?>