<?php 
/*-- Project Introduce --*/


class JCAT_JPDRDialogBrowser extends JCAT_JPDRCommander 
{	
	const BLOCK_OFF = 0 ;			// 不对新窗口做处理
	const BLOCK_ON = 1 ;				// 阻止新窗口
	const BLOCK_PARENT = 2 ;			// 在原对话框 中打开
	const BLOCK_DIALOG = 3 ;			// 在 CDHTMLDialog 对话框 中打开
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_JPDRDialogBrowser(JCAT_JPDRDialog $aJPDRDialog=null,$nBrowserWnd=null)
	{
		if($aJPDRDialog)
		{
			if( !$aJPDRDialog->IsAvailable() )
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'JCAT_JPDRDialogBrowser::JCAT_JPDRDialogBrowser() 传入的参数 \$aJPDRDialog 不是一个有效的 JCAT_JPDRDialog 对象'
					, 'JCAT', null
				)) ;
			}
		}
		else 
		{
			$aJPDRDialog = new JCAT_JPDRDialog() ;
		}
		
		if($nBrowserWnd)
		{
			if( $aJPDRDialog->GetDialogType($nBrowserWnd)!=JCAT_JPDRDialog::DLG_BROWSER )
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'JCAT_JPDRDialogBrowser::JCAT_JPDRDialogBrowser() 传入的参数 \$nBrowserWnd 必须为另一个参数 $aJPDRDialog 创建的窗口句柄。'
					, 'JCAT', null
				)) ;
			}
		}
		
		else 
		{
			$nBrowserWnd = $aJPDRDialog->Create(JCAT_JPDRDialog::DLG_BROWSER) ;
		}
		
		$this->aJPDRDialog = $aJPDRDialog ;
		$this->nBrowserWnd = $nBrowserWnd ;
		$this->JCAT_JPDRCommander($aJPDRDialog->GetCOM());
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function __destruct()
	{
		// JPDR Commander COM 里目前有一个 bug: 无法在 析构函数中 delete brouwer
		// 因此在 PHP对象 的析构函数中进行
		$this->Destroy() ;
		
		parent::__destruct() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function __toString()
	{
		return $this->GetWnd() ;
	}
	
	/**
	 * 移动鼠标
	 *
	 * @access	public
	 * @param	$sUrl					int
	 * @param	$sTargetFrameName		int
	 * @param	$sHeader				int
	 * @return	void
	 */
	public function Navigate($sUrl, $sTargetFrameName="", $sHeader="")
	{
		$this->CheckAvailable() ;
		$this->GetCOM()->Navigate($this->nBrowserWnd,$sUrl,$sTargetFrameName,$sHeader) ;
	}
	
	/**
	 * 取得当前打开的 url 
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetUrl()
	{
		$this->CheckAvailable() ;
		
		$sUrl = '' ;
		$this->GetCOM()->GetUrl($this->nBrowserWnd,$sUrl) ;
		return $sUrl ;
	}
	
	/**
	 * 刷新
	 *
	 * @access	public
	 * @return	void
	 */
	public function Refresh()
	{
		$this->Navigate($this->GetUrl()) ;
	}
	
	/**
	 * 执行 js 脚本
	 *
	 * @access	public
	 * @param	$sScript					string
	 * @param	$sLanguage="javascript"		string
	 * @return	void
	 */
	public function ExecScript($sScript,$sLanguage="javascript")
	{
		$this->CheckAvailable() ;
		$this->GetCOM()->ExecScript($this->nBrowserWnd,$sScript,$sLanguage) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsNavigateCompleted()
	{
		$this->CheckAvailable() ;
		
		$bCompleted = false ;
		$this->GetCOM()->IsNavigateCompleted($this->nBrowserWnd,$bCompleted) ;
		return $bCompleted ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsDocumentCompleted()
	{
		$this->CheckAvailable() ;
		
		$bCompleted = false ;
		$this->GetCOM()->IsDocumentCompleted($this->nBrowserWnd,$bCompleted) ;
		return $bCompleted ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function WaitingForDocumentComplate()
	{
		while( !$this->IsDocumentCompleted() )
		{
			usleep(200000) ; // 0.2
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sElementId		string		元素id
	 * @return	string
	 */
	public function GetElementHtml($sElementId)
	{
		$this->CheckAvailable() ;
		
		$sContent = '' ;
		$this->GetCOM()->GetElementHtml($this->nBrowserWnd,$sElementId,$sContent) ;
		return $sContent ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetHtmlBody()
	{
		$this->CheckAvailable() ;
		
		$sContent = '' ;
		$this->GetCOM()->GetHtmlBody($this->nBrowserWnd,$sContent) ;
		return $sContent ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$nBlockType
	 * @return	void
	 */
	public function SetBlockNewWindow($nBlockType=self::BLOCK_ON)
	{
		$this->CheckAvailable() ;
		$this->GetCOM()->SetBlockNewWindow($this->nBrowserWnd,$nBlockType) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Input		string,array	input的id，或  form name,input name 组成的数组
	 * @return	void
	 */
	public function SetInputValue($Input,$sValue)
	{
		if( is_array($Input) )
		{
			list($sFormName,$sInputName) = $Input ;
			$sGetInput = "document.{$sFormName}.{$sInputName}" ; 
		}
		
		else
		{
			$sGetInput = "document.getElementById('{$Input}')" ; 
		}
		
		$sValue = addslashes($sValue) ;
		$sScript = "{$sGetInput}.value=\"{$sValue}\"" ;
		
		$this->ExecScript("{$sGetInput}.focus()") ;
		$this->ExecScript($sScript) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Input				string,array	input的id，或  form name,input name 组成的数组
	 * @param	$bChecked=true
	 * @return	void
	 */
	public function SetChecked($Input,$bChecked=true)
	{
		if( is_array($Input) )
		{
			list($sFormName,$sInputName) = $Input ;
			$sGetInput = "document.{$sFormName}.{$sInputName}" ; 
		}
		
		else
		{
			$sGetInput = "document.getElementById('{$Input}')" ; 
		}
		
		if($bChecked)
		{
			$this->ExecScript("{$sGetInput}.click()") ;
		}
		
		else 
		{
			$this->ExecScript("{$sGetInput}.checked=false") ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Select				string,array	input的id，或  form name,select name 组成的数组
	 * @param	$nOptionIndex		int				可以用负数表示倒数
	 * @return	void
	 */
	public function SetSelected($Select,$nOptionIndex)
	{
		if( is_array($Select) )
		{
			list($sFormName,$sSelectName) = $Select ;
			$sGetSelect = "document.{$sFormName}.{$sSelectName}" ; 
		}
		
		else
		{
			$sGetSelect = "document.getElementById('{$Select}')" ; 
		}
		
		$nSelectedOption = ($nOptionIndex<0)? "{$sGetSelect}.options.length{$nOptionIndex}": $nOptionIndex ;
		$this->ExecScript("{$sGetSelect}.focus()") ;
		$this->ExecScript("{$sGetSelect}.options.selectedIndex = {$nSelectedOption}") ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sElementId
	 * @return	void
	 */
	public function SetElementFocus($sElementId,$bFocus=true)
	{
		$this->ExecScript(
			sprintf("document.getElementById('{$sElementId}').%s()",($bFocus?'focus':'blur'))
		) ;
	}
		
	/**
	 * Description
	 *
	 * @access	public
	 * @param 	$bDestroyOpens=true		bool	同时销毁所有从此窗口打开的其他窗口
	 * @return	bool
	 */
	public function Destroy($bDestroyOpens=true)
	{
		if($bDestroyOpens)
		{
			$arrWnds = $this->GetNewBrowsers() ;
			foreach($arrWnds as $nWnd)
			{
				$aOpenedBrowser = $this->GetAnotherBrowser($nWnd) ;
				$aOpenedBrowser->Destroy(true) ;
			}
		}
		
		return $this->aJPDRDialog->Destroy($this->nBrowserWnd) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetWnd()
	{
		return $this->nBrowserWnd ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetNewBrowsers()
	{
		$this->CheckAvailable() ;
		
		$sNewBrowsers = '' ;
		$this->GetCOM()->GetNewBrowsers($this->nBrowserWnd,$sNewBrowsers) ;
		
		$sNewBrowsers = trim($sNewBrowsers) ;
		return $sNewBrowsers? explode(',',$sNewBrowsers): array() ;		
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_JPDRWindowIterator
	 */
	public function CreateNewBrowserIter()
	{
		return new JCAT_JPDRWindowIterator($this->GetNewBrowsers()) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$nBrowserWnd		int
	 * @return	JCAT_JPDRDialogBrowser
	 */
	public function GetAnotherBrowser($nBrowserWnd)
	{
		// 无效的浏览器窗口句柄
		return $this->aJPDRDialog->GetDialogType($nBrowserWnd)?
				new JCAT_JPDRDialogBrowser($this->aJPDRDialog,$nBrowserWnd) : null ; 
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_JPDRDialog
	 */
	public function GetCommander()
	{
		return $this->aJPDRDialog ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_JPDRDialog
	 */
	private $aJPDRDialog ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nBrowserWnd ;
}
?>