<?php 
/*-- Project Introduce --*/


class JCAT_JPDRSysIM extends JCAT_JPDRCommander 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_JPDRSysIM()
	{
		try{
			$this->JCAT_JPDRCommander(new COM("JPDRWinCmd.SysInput.IM")) ;
		}
		catch (Exception $e)
		{
			throw new JCAT_Exception( JCAT::CharsetToProject($e->getMessage())) ;
		}
	}
	
	
	/**
	 * 返回所有的 输入法 代码(16进制 字符格式)
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetAllIMs()
	{
		$this->CheckAvailable() ;
		
		$sReturn = '' ;
		$this->GetCOM()->GetAllIMs($sReturn) ;
		
		$arrReturn = explode(',',$sReturn) ;
		return $arrReturn ;
	}
	
	
	/**
	 * 返回输入法名字
	 *
	 * @access	public
	 * @param 	$sIMCode
	 * @return	string
	 */
	public function GetIMName($sIMCode)
	{
		$this->CheckAvailable() ;
		
		$sReturn = '' ;
		$this->GetCOM()->GetIMName($sIMCode,$sReturn) ;
		return $sReturn? $sReturn: null ;
	}
	
	
	/**
	 * 返回提供输入法的dll文件名
	 *
	 * @access	public
	 * @param 	$sIMCode
	 * @return	string
	 */
	public function GetIMFile($sIMCode)
	{
		$this->CheckAvailable() ;
		
		$sReturn = '' ;
		$this->GetCOM()->GetIMFile($sIMCode,$sReturn) ;
		return $sReturn? $sReturn: null ;
	}
	
	
	/**
	 * 返回输入法的 IME 信息
	 *
	 * @access	public
	 * @param 	$sIMCode
	 * @return	string
	 */
	public function GetIME($sIMCode)
	{
		$this->CheckAvailable() ;
		
		$sReturn = '' ;
		$this->GetCOM()->GetIME($sIMCode,$sReturn) ;
		return $sReturn? $sReturn: null ;
	}
	
	
	/**
	 * 选择输入法
	 *
	 * @access	public
	 * @param 	$nWnd
	 * @param 	$IMCode		int,string
	 * @return	void
	 */
	public function SetIM($nWnd,$IMCode)
	{
		if( is_string($IMCode) )
		{
			$IMCode = hexdec($IMCode) ;
		}
		
		$this->CheckAvailable() ;
		$this->GetCOM()->SetIM($nWnd,intval($IMCode)) ;
	}

	/**
	 * 返回指定窗口的输入法
	 *
	 * @access	public
	 * @param 	$nThreadId
	 * @return	int
	 */
	public function GetIM($nThreadId=0)
	{
		$this->CheckAvailable() ;
		
		$nIMCode = 0 ;
		$this->GetCOM()->GetKeyboardLayout($nThreadId,$nIMCode) ;
		return $nIMCode ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$nThreadId
	 * @return	bool
	 */
	public function DisableIME($nThreadId)
	{
		$this->CheckAvailable() ;

		$bRes = false ;
		$this->GetCOM()->DisableIME($nThreadId,$bRes) ;
		return $bRes ;
	}

	/////////////////////////////////////////////
	//  windows 语系代码， 输入法代码的前 8位， 
	//  简体中文/和繁体中文 属于相同语系
	
	// Neutral 
	 const LANG_NEUTRAL = 0x00 ;

	// Arabic 
	 const LANG_ARABIC = 0x01 ;

	// Bulgarian 
	 const LANG_BULGARIAN = 0x02 ;

	// Catalan  
	 const LANG_CATALAN = 0x03 ;

	// Chinese 
	 const LANG_CHINESE = 0x04 ;

	// Czech 
	 const LANG_CZECH = 0x05 ;

	// Danish 
	 const LANG_DANISH = 0x06 ;

	// German 
	 const LANG_GERMAN = 0x07 ;

	// Greek 
	 const LANG_GREEK = 0x08 ;

	// English  
	 const LANG_ENGLISH = 0x09 ;

	// Spanish  
	 const LANG_SPANISH = 0x0a ;

	// Finnish 
	 const LANG_FINNISH = 0x0b ;

	// French 
	 const LANG_FRENCH = 0x0c ;

	// Hebrew 
	 const LANG_HEBREW = 0x0d ;

	// Hungarian 
	 const LANG_HUNGARIAN = 0x0e ;

	// Icelandic 
	 const LANG_ICELANDIC = 0x0f ;

	// Italian  
	 const LANG_ITALIAN = 0x10 ;

	// Japanese 
	 const LANG_JAPANESE = 0x11 ;

	// Korean 
	 const LANG_KOREAN = 0x12 ;

	// Dutch 
	 const LANG_DUTCH = 0x13 ;

	// Norwegian 
	 const LANG_NORWEGIAN = 0x14 ;

	// Polish 
	 const LANG_POLISH = 0x15 ;

	// Portuguese 
	 const LANG_PORTUGUESE = 0x16 ;

	// Romanian 
	 const LANG_ROMANIAN = 0x18 ;

	// Russian 
	 const LANG_RUSSIAN = 0x19 ;

	// Croatian 
	 const LANG_CROATIAN = 0x1a ;

	// Serbian 
	 const LANG_SERBIAN = 0x1a ;

	// Slovak 
	 const LANG_SLOVAK = 0x1b ;

	// Albanian 
	 const LANG_ALBANIAN = 0x1c ;

	// Swedish  
	 const LANG_SWEDISH = 0x1d ;

	// Thai 
	 const LANG_THAI = 0x1e ;

	// Turkish  
	 const LANG_TURKISH = 0x1f ;

	// Urdu 
	 const LANG_URDU = 0x20 ;

	// Indonesian 
	 const LANG_INDONESIAN = 0x21 ;

	// Ukrainian 
	 const LANG_UKRAINIAN = 0x22 ;

	// Belarusian 
	 const LANG_BELARUSIAN = 0x23 ;

	// Slovenian 
	 const LANG_SLOVENIAN = 0x24 ;

	// Estonian 
	 const LANG_ESTONIAN = 0x25 ;

	// Latvian 
	 const LANG_LATVIAN = 0x26 ;

	// Lithuanian 
	 const LANG_LITHUANIAN = 0x27 ;

	// Farsi 
	 const LANG_FARSI = 0x29 ;

	// Vietnamese 
	 const LANG_VIETNAMESE = 0x2a ;

	// Armenian 
	 const LANG_ARMENIAN = 0x2b ;

	// Azeri 
	 const LANG_AZERI = 0x2c ;

	// Basque 
	 const LANG_BASQUE = 0x2d ;

	// Macedonian (FYROM) 
	 const LANG_MACEDONIAN = 0x2f ;

	// Afrikaans 
	 const LANG_AFRIKAANS = 0x36 ;

	// Georgian 
	 const LANG_GEORGIAN = 0x37 ;

	// Faeroese 
	 const LANG_FAEROESE = 0x38 ;

	// Hindi 
	 const LANG_HINDI = 0x39 ;

	// Malay 
	 const LANG_MALAY = 0x3e ;

	// Kazak 
	 const LANG_KAZAK = 0x3f ;

	// Kyrgyz 
	 const LANG_KYRGYZ = 0x40 ;

	// Swahili 
	 const LANG_SWAHILI = 0x41 ;

	// Uzbek 
	 const LANG_UZBEK = 0x43 ;

	// Tatar 
	 const LANG_TATAR = 0x44 ;

	// Not supported. 
	 const LANG_BENGALI = 0x45 ;

	// Punjabi 
	 const LANG_PUNJABI = 0x46 ;

	// Gujarati 
	 const LANG_GUJARATI = 0x47 ;

	// Not supported. 
	 const LANG_ORIYA = 0x48 ;

	// Tamil 
	 const LANG_TAMIL = 0x49 ;

	// Telugu 
	 const LANG_TELUGU = 0x4a ;

	// Kannada 
	 const LANG_KANNADA = 0x4b ;

	// Not supported. 
	 const LANG_MALAYALAM = 0x4c ;

	// Not supported. 
	 const LANG_ASSAMESE = 0x4d ;

	// Marathi 
	 const LANG_MARATHI = 0x4e ;

	// Sanskrit 
	 const LANG_SANSKRIT = 0x4f ;

	// Mongolian 
	 const LANG_MONGOLIAN = 0x50 ;

	// Galician 
	 const LANG_GALICIAN = 0x56 ;

	// Konkani 
	 const LANG_KONKANI = 0x57 ;

	// Not supported. 
	 const LANG_MANIPURI = 0x58 ;

	// Not supported. 
	 const LANG_SINDHI = 0x59 ;

	// Syriac 
	 const LANG_SYRIAC = 0x5a ;

	// Not supported. 
	 const LANG_KASHMIRI = 0x60 ;

	// Not supported. 
	 const LANG_NEPALI = 0x61 ;

	// Divehi 
	 const LANG_DIVEHI = 0x65 ;


	/////////////////////////////////////////////
	//  语言代码 对应 (输入法代码 前16位)
	/*
		0x0000 Language Neutral 
		0x007f The language for the invariant locale (LOCALE_INVARIANT). See MAKELCID. 
		0x0400 Process or User Default Language 
		0x0800 System Default Language 
		0x0436 Afrikaans 
		0x041c Albanian 
		0x0401 Arabic (Saudi Arabia) 
		0x0801 Arabic (Iraq) 
		0x0c01 Arabic (Egypt) 
		0x1001 Arabic (Libya) 
		0x1401 Arabic (Algeria) 
		0x1801 Arabic (Morocco) 
		0x1c01 Arabic (Tunisia) 
		0x2001 Arabic (Oman) 
		0x2401 Arabic (Yemen) 
		0x2801 Arabic (Syria) 
		0x2c01 Arabic (Jordan) 
		0x3001 Arabic (Lebanon) 
		0x3401 Arabic (Kuwait) 
		0x3801 Arabic (U.A.E.) 
		0x3c01 Arabic (Bahrain) 
		0x4001 Arabic (Qatar) 
		0x042b Windows 2000/XP: Armenian. This is Unicode only. 
		0x042c Azeri (Latin) 
		0x082c Azeri (Cyrillic) 
		0x042d Basque 
		0x0423 Belarusian 
		0x0445 Bengali (India) 
		0x141a Bosnian (Bosnia and Herzegovina) 
		0x0402 Bulgarian 
		0x0455 Burmese 
		0x0403 Catalan 
		0x0404 Chinese (Taiwan) 
		0x0804 Chinese (PRC) 
		0x0c04 Chinese (Hong Kong SAR, PRC) 
		0x1004 Chinese (Singapore) 
		0x1404 Windows 98/Me, Windows 2000/XP: Chinese (Macao SAR) 
		0x041a Croatian 
		0x101a Croatian (Bosnia and Herzegovina) 
		0x0405 Czech 
		0x0406 Danish 
		0x0465 Windows XP: Divehi. This is Unicode only. 
		0x0413 Dutch (Netherlands) 
		0x0813 Dutch (Belgium) 
		0x0409 English (United States) 
		0x0809 English (United Kingdom) 
		0x0c09 English (Australian) 
		0x1009 English (Canadian) 
		0x1409 English (New Zealand) 
		0x1809 English (Ireland) 
		0x1c09 English (South Africa) 
		0x2009 English (Jamaica) 
		0x2409 English (Caribbean) 
		0x2809 English (Belize) 
		0x2c09 English (Trinidad) 
		0x3009 Windows 98/Me, Windows 2000/XP: English (Zimbabwe) 
		0x3409 Windows 98/Me, Windows 2000/XP: English (Philippines) 
		0x0425 Estonian 
		0x0438 Faeroese 
		0x0429 Farsi 
		0x040b Finnish 
		0x040c French (Standard) 
		0x080c French (Belgian) 
		0x0c0c French (Canadian) 
		0x100c French (Switzerland) 
		0x140c French (Luxembourg) 
		0x180c Windows 98/Me, Windows 2000/XP: French (Monaco) 
		0x0456 Windows XP: Galician 
		0x0437 Windows 2000/XP: Georgian. This is Unicode only. 
		0x0407 German (Standard) 
		0x0807 German (Switzerland) 
		0x0c07 German (Austria) 
		0x1007 German (Luxembourg) 
		0x1407 German (Liechtenstein) 
		0x0408 Greek 
		0x0447 Windows XP: Gujarati. This is Unicode only. 
		0x040d Hebrew 
		0x0439 Windows 2000/XP: Hindi. This is Unicode only. 
		0x040e Hungarian 
		0x040f Icelandic 
		0x0421 Indonesian 
		0x0434 isiXhosa/Xhosa (South Africa) 
		0x0435 isiZulu/Zulu (South Africa) 
		0x0410 Italian (Standard) 
		0x0810 Italian (Switzerland) 
		0x0411 Japanese 
		0x044b Windows XP: Kannada. This is Unicode only. 
		0x0457 Windows 2000/XP: Konkani. This is Unicode only. 
		0x0412 Korean 
		0x0812 Windows 95, Windows NT 4.0 only: Korean (Johab) 
		0x0440 Windows XP: Kyrgyz. 
		0x0426 Latvian 
		0x0427 Lithuanian 
		0x0827 Windows 98 only: Lithuanian (Classic) 
		0x042f Macedonian (FYROM) 
		0x043e Malay (Malaysian) 
		0x083e Malay (Brunei Darussalam) 
		0x044c Malayalam (India) 
		0x0481 Maori (New Zealand) 
		0x043a Maltese (Malta) 
		0x044e Windows 2000/XP: Marathi. This is Unicode only. 
		0x0450 Windows XP: Mongolian 
		0x0414 Norwegian (Bokmal) 
		0x0814 Norwegian (Nynorsk) 
		0x0415 Polish 
		0x0416 Portuguese (Brazil) 
		0x0816 Portuguese (Portugal) 
		0x0446 Windows XP: Punjabi. This is Unicode only. 
		0x046b Quechua (Bolivia) 
		0x086b Quechua (Ecuador) 
		0x0c6b Quechua (Peru) 
		0x0418 Romanian 
		0x0419 Russian 
		0x044f Windows 2000/XP: Sanskrit. This is Unicode only. 
		0x043b Sami, Northern (Norway) 
		0x083b Sami, Northern (Sweden) 
		0x0c3b Sami, Northern (Finland) 
		0x103b Sami, Lule (Norway) 
		0x143b Sami, Lule (Sweden) 
		0x183b Sami, Southern (Norway) 
		0x1c3b Sami, Southern (Sweden) 
		0x203b Sami, Skolt (Finland) 
		0x243b Sami, Inari (Finland) 
		0x0c1a Serbian (Cyrillic) 
		0x1c1a Serbian (Cyrillic, Bosnia, and Herzegovina) 
		0x081a Serbian (Latin) 
		0x181a Serbian (Latin, Bosnia, and Herzegovina) 
		0x046c Sesotho sa Leboa/Northern Sotho (South Africa) 
		0x0432 Setswana/Tswana (South Africa) 
		0x041b Slovak 
		0x0424 Slovenian 
		0x040a Spanish (Spain, Traditional Sort) 
		0x080a Spanish (Mexican) 
		0x0c0a Spanish (Spain, Modern Sort) 
		0x100a Spanish (Guatemala) 
		0x140a Spanish (Costa Rica) 
		0x180a Spanish (Panama) 
		0x1c0a Spanish (Dominican Republic) 
		0x200a Spanish (Venezuela) 
		0x240a Spanish (Colombia) 
		0x280a Spanish (Peru) 
		0x2c0a Spanish (Argentina) 
		0x300a Spanish (Ecuador) 
		0x340a Spanish (Chile) 
		0x380a Spanish (Uruguay) 
		0x3c0a Spanish (Paraguay) 
		0x400a Spanish (Bolivia) 
		0x440a Spanish (El Salvador) 
		0x480a Spanish (Honduras) 
		0x4c0a Spanish (Nicaragua) 
		0x500a Spanish (Puerto Rico) 
		0x0430 Sutu 
		0x0441 Swahili (Kenya) 
		0x041d Swedish 
		0x081d Swedish (Finland) 
		0x045a Windows XP: Syriac. This is Unicode only. 
		0x0449 Windows 2000/XP: Tamil. This is Unicode only. 
		0x0444 Tatar (Tatarstan) 
		0x044a Windows XP: Telugu. This is Unicode only. 
		0x041e Thai 
		0x041f Turkish 
		0x0422 Ukrainian 
		0x0420 Windows 98/Me, Windows 2000/XP: Urdu (Pakistan) 
		0x0820 Urdu (India) 
		0x0443 Uzbek (Latin) 
		0x0843 Uzbek (Cyrillic) 
		0x042a Windows 98/Me, Windows NT 4.0 and later: Vietnamese 
		0x0452 Welsh (United Kingdom) 
	 * 
	 */
	
	
}
?>