<?php 
/*-- Project Introduce --*/


class JCAT_JPDRSysInput extends JCAT_JPDRCommander
{
	const MOUSE_LEFT = 1 ;		// 鼠标左键
	const MOUSE_RIGHT = 2 ;		// 鼠标右键
	const MOUSE_MIDDLE = 4 ;	// 鼠标中键

	const MOUSE_DOWN = 16 ;		// 鼠标按下
	const MOUSE_UP = 32 ;		// 鼠标弹起
	const MOUSE_CLICK = 48 ;	// 鼠标单击
	const MOUSE_DCLICK = 64 ;	// 鼠标双击
	const MOUSE_MAX = 64 ;
	
	const LEFT_CLICK = 49 ;		// 点击鼠标左键  MOUSE_LEFT|MOUSE_CLICK
	const RIGHT_CLICK = 50 ;	// 点击鼠标右键键  MOUSE_RIGHT|MOUSE_CLICK
	
	
	const KEY_DOWN = 1 ;		// 键盘按下
	const KEY_UP = 2 ;			// 键盘弹起
	const KEY_PRESS = 3 ;		// 键盘按下/弹起
	const KEY_VIRTUAL = 8 ;		// 虚拟键
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_JPDRSysInput()
	{
		try{
			$this->JCAT_JPDRCommander(new COM("JPDRWinCmd.SysInput")) ;
		}
		catch (Exception $e)
		{
			throw new JCAT_Exception( JCAT::CharsetToProject($e->getMessage())) ;
		}
	}
	
	
	/**
	 * 移动鼠标
	 *
	 * @access	public
	 * @param	$nX		int
	 * @param	$nY		int
	 * @return	void
	 */
	public function MoveTo($nX,$nY)
	{
		$this->CheckAvailable() ;
		$this->GetCOM()->MoveTo($nX,$nY) ;
	}
	
	/**
	 * 移动鼠标
	 *
	 * @access	public
	 * @param	$nWhichBtn		int
	 * @param	$nY		int
	 * @return	void
	 */
	public function Click($nClickFlg=self::LEFT_CLICK)
	{
		$this->CheckAvailable() ;
		
		$nWhichBtn = ($nClickFlg&15) ;
		$nDoWhat = ($nClickFlg>>4)<<4 ;
		
		$this->GetCOM()->Click($nWhichBtn,$nDoWhat) ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function Key($WhickKey,$nDoWhat=self::KEY_PRESS)
	{
		$this->CheckAvailable() ;
		
		if (is_string($WhickKey))
		{
			$WhickKey = ord($WhickKey) ;
		}
		$this->GetCOM()->Key($WhickKey,$nDoWhat) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function VKey($nWhickKey,$nDoWhat=self::KEY_PRESS)
	{
		$nDoWhat|= self::KEY_VIRTUAL ;
		$this->Key($nWhickKey,$nDoWhat) ;
	}
	
	/**
	 * 修饰键(modifier key)
	 *
	 * @access	public
	 * @param	$WhickKey							string,int
	 * @param	$nModifierVKey=self::VK_CONTROL		string,int
	 * @return	void
	 */
	public function MKey($WhickKey,$nModifierVKey=self::VK_CONTROL)
	{
		if( is_int($WhickKey) )
		{
			$nKeyFlg = self::KEY_PRESS|self::KEY_VIRTUAL ;
		}
		
		else
		{
			$WhickKey = ord($WhickKey) ;
			$nKeyFlg = self::KEY_PRESS ;
		}
		
		// 按下  修饰键
		$this->VKey($nModifierVKey,self::KEY_DOWN) ;
		usleep(50000) ; // 0.05 sec
		
		// 按键
		$this->Key($WhickKey,$nKeyFlg) ;
		usleep(50000) ; // 0.05 sec
		
		// 释放 修饰键
		$this->VKey($nModifierVKey,self::KEY_UP) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sString			string
	 * @param	$nInterval=0.01		float		秒
	 * @return	void
	 */
	public function KeyString($sString,$nInterval=0.001)
	{
		$nInterval*= 1000000 ; 
		
		for($i=0;$i<strlen($sString);$i++)
		{
			$sChar = substr($sString,$i,1) ;
			$this->Key($sChar,self::KEY_PRESS) ;

			usleep($nInterval);
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$bBlock=true		bool
	 * @return	bool
	 */
	public function BlockInput($bBlock=true)
	{
		$this->CheckAvailable() ;
		
		$bRes = false ;
		$this->GetCOM()->BlockInput($bBlock?true:false,$bRes) ;
		return $bRes ;
	}
	
	/**
	 * 将 ascii 码转换成 virtual key 的键码，以及输入该字符所需的修饰键状态
	 * 返回值为 short 类型， 其中 低位字节为 virtual key 键码，
	 * 高位字节 表示 需要使用的修饰键状态（已经将 Caps Lock 键的状态考虑在内）
	 * 高位字节各个位 所代表的意义如下：
	 *   1 Either SHIFT key is pressed. 
	 *   2 Either CTRL key is pressed. 
	 *   4 Either ALT key is pressed.  
	 *   8 The Hankaku key is pressed 
	 *
	 * @access	public
	 * @param	$Char	string,int
	 * @return	int
	 */
	public function QueryVirtualKey($Char)
	{
		$nVKeyScan = $this->QueryVKeyScan($Char) ;
		return ($nVKeyScan&self::VKSCAN_MAXVK) ;
	}
	
	/**
	 * 传入给定的 ascii 码转，换成对应的 virtual key 的键码和 ctrl、shift、alt 状态
	 *
	 * @access	public
	 * @param	$Char	string,int
	 * @return	int
	 */
	public function QueryVKeyScan($Char)
	{
		$this->CheckAvailable() ;
		
		if (is_string($Char))
		{
			$Char = ord($Char) ;
		}
		$nVKeyScan = 0 ;
		$this->GetCOM()->QueryVKeyScan($Char,$nVKeyScan) ;
		return $nVKeyScan ;
	}
	
	const VKSCAN_SHIFT	 = 0x0100 ;		// 00000001 00000000
	const VKSCAN_CTRL	 = 0x0200 ;		// 00000010 00000000
	const VKSCAN_ALT	 = 0x0400 ;		// 00000100 00000000
	const VKSCAN_MAXVK	 = 0x00FF ;		// 00000000 11111111
	
	//////////////////////////////////////////////////////////////////
	//  虚拟键
	
	// Left mouse button
	const VK_LBUTTON = 0x01 ;

	// Right mouse button
	const VK_RBUTTON = 0x02 ;

	// Control-break processing
	const VK_CANCEL = 0x03 ;

	// Middle mouse button (three-button mouse)
	const VK_MBUTTON = 0x04 ;

	// Windows 2000/XP: X1 mouse button
	const VK_XBUTTON1 = 0x05 ;

	// Windows 2000/XP: X2 mouse button
	const VK_XBUTTON2 = 0x06 ;

	// BACKSPACE key
	const VK_BACK = 0x08 ;

	// TAB key
	const VK_TAB = 0x09 ;

	// CLEAR key
	const VK_CLEAR = 0x0C ;

	// ENTER key
	const VK_RETURN = 0x0D ;

	// SHIFT key
	const VK_SHIFT = 0x10 ;

	// CTRL key
	const VK_CONTROL = 0x11 ;

	// ALT key
	const VK_MENU = 0x12 ;

	// PAUSE key
	const VK_PAUSE = 0x13 ;

	// CAPS LOCK key
	const VK_CAPITAL = 0x14 ;

	// Input Method Editor (IME) Kana mode
	const VK_KANA = 0x15 ;

	// IME Hanguel mode (maintained for compatibility; use VK_HANGUL)
	const VK_HANGUEL = 0x15 ;

	// IME Hangul mode
	const VK_HANGUL = 0x15 ;

	// IME Junja mode
	const VK_JUNJA = 0x17 ;

	// IME final mode
	const VK_FINAL = 0x18 ;

	// IME Hanja mode
	const VK_HANJA = 0x19 ;

	// IME Kanji mode
	const VK_KANJI = 0x19 ;

	// ESC key
	const VK_ESCAPE = 0x1B ;

	// IME convert
	const VK_CONVERT = 0x1C ;

	// IME nonconvert
	const VK_NONCONVERT = 0x1D ;

	// IME accept
	const VK_ACCEPT = 0x1E ;

	// IME mode change request
	const VK_MODECHANGE = 0x1F ;

	// SPACEBAR
	const VK_SPACE = 0x20 ;

	// PAGE UP key
	const VK_PRIOR = 0x21 ;

	// PAGE DOWN key
	const VK_NEXT = 0x22 ;

	// END key
	const VK_END = 0x23 ;

	// HOME key
	const VK_HOME = 0x24 ;

	// LEFT ARROW key
	const VK_LEFT = 0x25 ;

	// UP ARROW key
	const VK_UP = 0x26 ;

	// RIGHT ARROW key
	const VK_RIGHT = 0x27 ;

	// DOWN ARROW key
	const VK_DOWN = 0x28 ;

	// SELECT key
	const VK_SELECT = 0x29 ;

	// PRINT key
	const VK_PRINT = 0x2A ;

	// EXECUTE key
	const VK_EXECUTE = 0x2B ;

	// PRINT SCREEN key
	const VK_SNAPSHOT = 0x2C ;

	// INS key
	const VK_INSERT = 0x2D ;

	// DEL key
	const VK_DELETE = 0x2E ;

	// HELP key
	const VK_HELP = 0x2F ;

	// 0 key
	const VK_0 = 0x30 ;

	// 1 key
	const VK_1 = 0x31 ;

	// 2 key
	const VK_2 = 0x32 ;

	// 3 key
	const VK_3 = 0x33 ;

	// 4 key
	const VK_4 = 0x34 ;

	// 5 key
	const VK_5 = 0x35 ;

	// 6 key
	const VK_6 = 0x36 ;

	// 7 key
	const VK_7 = 0x37 ;

	// 8 key
	const VK_8 = 0x38 ;

	// 9 key
	const VK_9 = 0x39 ;

	// A key
	const VK_A = 0x41 ;

	// B key
	const VK_B = 0x42 ;

	// C key
	const VK_C = 0x43 ;

	// D key
	const VK_D = 0x44 ;

	// E key
	const VK_E = 0x45 ;

	// F key
	const VK_F = 0x46 ;

	// G key
	const VK_G = 0x47 ;

	// H key
	const VK_H = 0x48 ;

	// I key
	const VK_I = 0x49 ;

	// J key
	const VK_J = 0x4A ;

	// K key
	const VK_K = 0x4B ;

	// L key
	const VK_L = 0x4C ;

	// M key
	const VK_M = 0x4D ;

	// N key
	const VK_N = 0x4E ;

	// O key
	const VK_O = 0x4F ;

	// P key
	const VK_P = 0x50 ;

	// Q key
	const VK_Q = 0x51 ;

	// R key
	const VK_R = 0x52 ;

	// S key
	const VK_S = 0x53 ;

	// T key
	const VK_T = 0x54 ;

	// U key
	const VK_U = 0x55 ;

	// V key
	const VK_V = 0x56 ;

	// W key
	const VK_W = 0x57 ;

	// X key
	const VK_X = 0x58 ;

	// Y key
	const VK_Y = 0x59 ;

	// Z key
	const VK_Z = 0x5A ;

	// Left Windows key (Microsoft Natural keyboard) 
	const VK_LWIN = 0x5B ;

	// Right Windows key (Natural keyboard)
	const VK_RWIN = 0x5C ;

	// Applications key (Natural keyboard)
	const VK_APPS = 0x5D ;

	// Computer Sleep key
	const VK_SLEEP = 0x5F ;

	// Numeric keypad 0 key
	const VK_NUMPAD0 = 0x60 ;

	// Numeric keypad 1 key
	const VK_NUMPAD1 = 0x61 ;

	// Numeric keypad 2 key
	const VK_NUMPAD2 = 0x62 ;

	// Numeric keypad 3 key
	const VK_NUMPAD3 = 0x63 ;

	// Numeric keypad 4 key
	const VK_NUMPAD4 = 0x64 ;

	// Numeric keypad 5 key
	const VK_NUMPAD5 = 0x65 ;

	// Numeric keypad 6 key
	const VK_NUMPAD6 = 0x66 ;

	// Numeric keypad 7 key
	const VK_NUMPAD7 = 0x67 ;

	// Numeric keypad 8 key
	const VK_NUMPAD8 = 0x68 ;

	// Numeric keypad 9 key
	const VK_NUMPAD9 = 0x69 ;

	// Multiply key
	const VK_MULTIPLY = 0x6A ;

	// Add key
	const VK_ADD = 0x6B ;

	// Separator key
	const VK_SEPARATOR = 0x6C ;

	// Subtract key
	const VK_SUBTRACT = 0x6D ;

	// Decimal key
	const VK_DECIMAL = 0x6E ;

	// Divide key
	const VK_DIVIDE = 0x6F ;

	// F1 key
	const VK_F1 = 0x70 ;

	// F2 key
	const VK_F2 = 0x71 ;

	// F3 key
	const VK_F3 = 0x72 ;

	// F4 key
	const VK_F4 = 0x73 ;

	// F5 key
	const VK_F5 = 0x74 ;

	// F6 key
	const VK_F6 = 0x75 ;

	// F7 key
	const VK_F7 = 0x76 ;

	// F8 key
	const VK_F8 = 0x77 ;

	// F9 key
	const VK_F9 = 0x78 ;

	// F10 key
	const VK_F10 = 0x79 ;

	// F11 key
	const VK_F11 = 0x7A ;

	// F12 key
	const VK_F12 = 0x7B ;

	// F13 key
	const VK_F13 = 0x7C ;

	// F14 key
	const VK_F14 = 0x7D ;

	// F15 key
	const VK_F15 = 0x7E ;

	// F16 key
	const VK_F16 = 0x7F ;

	// F17 key
	const VK_F17 = 0x80 ;

	// F18 key
	const VK_F18 = 0x81 ;

	// F19 key
	const VK_F19 = 0x82 ;

	// F20 key
	const VK_F20 = 0x83 ;

	// F21 key
	const VK_F21 = 0x84 ;

	// F22 key
	const VK_F22 = 0x85 ;

	// F23 key
	const VK_F23 = 0x86 ;

	// F24 key
	const VK_F24 = 0x87 ;

	// NUM LOCK key
	const VK_NUMLOCK = 0x90 ;

	// SCROLL LOCK key
	const VK_SCROLL = 0x91 ;

	// Left SHIFT key
	const VK_LSHIFT = 0xA0 ;

	// Right SHIFT key
	const VK_RSHIFT = 0xA1 ;

	// Left CONTROL key
	const VK_LCONTROL = 0xA2 ;

	// Right CONTROL key
	const VK_RCONTROL = 0xA3 ;

	// Left MENU key
	const VK_LMENU = 0xA4 ;

	// Right MENU key
	const VK_RMENU = 0xA5 ;

	// Windows 2000/XP: Browser Back key
	const VK_BROWSER_BACK = 0xA6 ;

	// Windows 2000/XP: Browser Forward key
	const VK_BROWSER_FORWARD = 0xA7 ;

	// Windows 2000/XP: Browser Refresh key
	const VK_BROWSER_REFRESH = 0xA8 ;

	// Windows 2000/XP: Browser Stop key
	const VK_BROWSER_STOP = 0xA9 ;

	// Windows 2000/XP: Browser Search key 
	const VK_BROWSER_SEARCH = 0xAA ;

	// Windows 2000/XP: Browser Favorites key
	const VK_BROWSER_FAVORITES = 0xAB ;

	// Windows 2000/XP: Browser Start and Home key
	const VK_BROWSER_HOME = 0xAC ;

	// Windows 2000/XP: Volume Mute key
	const VK_VOLUME_MUTE = 0xAD ;

	// Windows 2000/XP: Volume Down key
	const VK_VOLUME_DOWN = 0xAE ;

	// Windows 2000/XP: Volume Up key
	const VK_VOLUME_UP = 0xAF ;

	// Windows 2000/XP: Next Track key
	const VK_MEDIA_NEXT_TRACK = 0xB0 ;

	// Windows 2000/XP: Previous Track key
	const VK_MEDIA_PREV_TRACK = 0xB1 ;

	// Windows 2000/XP: Stop Media key
	const VK_MEDIA_STOP = 0xB2 ;

	// Windows 2000/XP: Play/Pause Media key
	const VK_MEDIA_PLAY_PAUSE = 0xB3 ;

	// Windows 2000/XP: Start Mail key
	const VK_LAUNCH_MAIL = 0xB4 ;

	// Windows 2000/XP: Select Media key
	const VK_LAUNCH_MEDIA_SELECT = 0xB5 ;

	// Windows 2000/XP: Start Application 1 key
	const VK_LAUNCH_APP1 = 0xB6 ;

	// Windows 2000/XP: Start Application 2 key
	const VK_LAUNCH_APP2 = 0xB7 ;

	// Used for miscellaneous characters; it can vary by keyboard.
	// Windows 2000/XP: For the US standard keyboard, the ';:' key 
	const VK_OEM_1 = 0xBA ;


	// Windows 2000/XP: For any country/region, the '+' key
	const VK_OEM_PLUS = 0xBB ;

	// Windows 2000/XP: For any country/region, the ',' key
	const VK_OEM_COMMA = 0xBC ;

	// Windows 2000/XP: For any country/region, the '-' key
	const VK_OEM_MINUS = 0xBD ;

	// Windows 2000/XP: For any country/region, the '.' key
	const VK_OEM_PERIOD = 0xBE ;

	// Used for miscellaneous characters; it can vary by keyboard.
	// Windows 2000/XP: For the US standard keyboard, the '/?' key 
	const VK_OEM_2 = 0xBF ;

	// Used for miscellaneous characters; it can vary by keyboard.
	// Windows 2000/XP: For the US standard keyboard, the '`~' key 
	const VK_OEM_3 = 0xC0 ;
 
	// Used for miscellaneous characters; it can vary by keyboard.
	// Windows 2000/XP: For the US standard keyboard, the '[{' key 
	const VK_OEM_4 = 0xDB ;

	// Used for miscellaneous characters; it can vary by keyboard.
	// Windows 2000/XP: For the US standard keyboard, the '\|' key 
	const VK_OEM_5 = 0xDC ;

	// Used for miscellaneous characters; it can vary by keyboard. 
	// Windows 2000/XP: For the US standard keyboard, the ']}' key
	const VK_OEM_6 = 0xDD ;

	// Used for miscellaneous characters; it can vary by keyboard.
	// Windows 2000/XP: For the US standard keyboard, the 'single-quote/double-quote' key 
	const VK_OEM_7 = 0xDE ;

	// Used for miscellaneous characters; it can vary by keyboard.
	const VK_OEM_8 = 0xDF ;

	// Windows 2000/XP: Either the angle bracket key or the backslash key on the RT 102-key keyboard
	const VK_OEM_102 = 0xE2 ;

	// Windows 95/98/Me, Windows NT 4.0, Windows 2000/XP: IME PROCESS key
	const VK_PROCESSKEY = 0xE5 ;

	// Windows 2000/XP: Used to pass Unicode characters as if they were keystrokes. The VK_PACKET key is the low word of a 32-bit Virtual Key value used for non-keyboard input methods. For more information, see Remark in KEYBDINPUT, SendInput, WM_KEYDOWN, and WM_KEYUP
	const VK_PACKET = 0xE7 ;

	// Attn key
	const VK_ATTN = 0xF6 ;

	// CrSel key
	const VK_CRSEL = 0xF7 ;

	// ExSel key
	const VK_EXSEL = 0xF8 ;

	// Erase EOF key
	const VK_EREOF = 0xF9 ;

	// Play key
	const VK_PLAY = 0xFA ;

	// Zoom key
	const VK_ZOOM = 0xFB ;

	// Reserved 
	const VK_NONAME = 0xFC ;

	// PA1 key
	const VK_PA1 = 0xFD ;

	// Clear key
	const VK_OEM_CLEAR = 0xFE ;
}
?>