<?php 
/*-- Project Introduce --*/


class JCAT_JPDRSystem extends JCAT_JPDRCommander 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_JPDRSystem()
	{
		try{
			$this->JCAT_JPDRCommander(new COM("JPDRWinCmd.System")) ;
		}
		catch (Exception $e)
		{
			throw new JCAT_Exception( JCAT::CharsetToProject($e->getMessage())) ;
		}
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetCpuSn()
	{
		$this->CheckAvailable() ;
		
		$sRet = '' ;
		try{
		$this->GetCOM()->GetCPUSN($sRet) ;
		}
		catch(Exception $e)
		{
			JCAT_Gtk::MessageDialog($e->getMessage()) ;
		}
		return $sRet ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetHardDiskSn()
	{
		$this->CheckAvailable() ;
		
		$sRet = '' ;
		$this->GetCOM()->GetHDSN($sRet) ;
		return $sRet ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sFile=''							string
	 * @param	$sParam=''							string
	 * @param	$sOperation							string		"edit","explore","find","open","print"
	 * @param	$sWorkDir=''						string
	 * @param	$nShow=JCAT_JPDRWindow::SW_SHOW		int
	 * @param	$nOwnerWnd=0						int
	 * @return	bool
	 */
	public function ShellExecute($sFile,$sParam='',$sOperation='open',$sWorkDir='',$nShow=JCAT_JPDRWindow::SW_SHOW,$nOwnerWnd=0)
	{
		$this->CheckAvailable() ;
		
		$nRet = 0 ;
		$this->GetCOM()->ShellExecute($nOwnerWnd,$sOperation,$sFile,$sParam,$sWorkDir,$nShow,$nRet) ;
		return ($nRet>32) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$nProcess		int
	 * @param	$nExitCode=0	int 
	 * @return	bool
	 */
	public function TerminateProcess($nProcess,$nExitCode=0)
	{
		$this->CheckAvailable() ;
		
		$bRes = false ;
		$this->GetCOM()->TerminateProcess($nProcess,$nExitCode,$bRes) ;
		return $bRes ;
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetLastError()
	{
		$this->CheckAvailable() ;
		
		$nError = 0 ;
		$this->GetCOM()->GetLastError($nError) ;
		return $nError ;
	}
	
	
}
?>