<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_PatchModify
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_PatchModify($nSourceLine,$nLineCount)
	{
		$this->nSourceLine = $nSourceLine ;
		$this->nLineCount = $nLineCount ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetSourceLine()
	{
		return $this->nSourceLine ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetLineCount()
	{
		return $this->nLineCount ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function ParseModify($sModify)
	{
		
		$aRegexp = new JCAT_Preg("/[^\\n]*\\n/") ;
		if( !$aRegexp->Match($sModify) )
		{
			return ;
		}
		
		$arrSourceLines = array() ;
		$arrNewLines = array() ;
		$arrLastLines = array() ;
		
		$aIterator = $aRegexp->CreateResultIter() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$sLine = $aIterator->Current() ;
			
			$sModifyType = substr($sLine,0,1) ;
			switch ($sModifyType)
			{
				// 保持不变
				case ' ' :
					$sLine = substr($sLine,1) ;
					$arrSourceLines[] = $sLine ;
					$arrNewLines[] = $sLine ;
					
					$arrLastLines = array(
							& $arrSourceLines[ count($arrSourceLines)-1 ]
							, & $arrNewLines[ count($arrNewLines)-1 ]
					) ;
					break ;
					
				// 删除
				case '-' :
					$arrSourceLines[] = substr($sLine,1) ;
					$arrLastLines = array(
							& $arrSourceLines[ count($arrSourceLines)-1 ]
					) ;
					break ;
				
				// 增加
				case '+' :
					$arrNewLines[] = substr($sLine,1) ;
					$arrLastLines = array(
							& $arrNewLines[ count($arrNewLines)-1 ]
					) ;
					break ;
				
				default :
					
					// 指示 无换行符
					if( preg_match("/^\\\\ No newline at end of file/i",$sLine) )
					{
						foreach ($arrLastLines as &$sLastLine)
						{
							$sLastLine = preg_replace("/\\n$/",'',$sLastLine) ;
						}
					}
					
					$arrLastLines = array() ;
					break ;
			}
		}
		
		
		$this->sSource = implode('',$arrSourceLines) ;
		$this->sNew = implode('',$arrNewLines) ;
		
		return ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sSource		JCAT_String
	 * @return	void
	 */
	public function Apply(array &$arrSourceLines)
	{
		$nSourceLine = $this->GetSourceLine() ;
		$arrSourceLines[$nSourceLine] = $this->sNew ;
		
		// 删除接下来的内容
		$nLineCount = $this->GetLineCount() ; 
		for($n=1;$n<$nLineCount;$n++)
		{
			unset($arrSourceLines[$nSourceLine+$n]) ;
		}
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nSourceLine = 0 ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nLineCount = 0 ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sSource = '' ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sNew = '' ;
	
}

?>