<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_FSPreference.php 2020 2009-09-16 06:02:46Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * 用文件系统实现的 配置类.
 *
 * @author		alee
 * @access		public
 */
class JCAT_FSPreference implements JCAT_IPreference
{


	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$sRootStoreDirectory	string	根存储目录
	 * @return	void
	 */
	public function JCAT_FSPreference( $sStoreDirectory ) 
	{		
		$this->aRootKey = new JCAT_FSPreferenceKey($sStoreDirectory) ;
	}

	


	/**
	 * 设置一个数据项
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @param	$sItemName		string	数据项名称
	 * @param	$Data			mixed	数据
	 * @return	old_value
	 */
	public function SetItem(  $sKeyPath,  $sItemName,  $Data ) 
	{
		return $this->GetKey($sKeyPath)->SetItem($sItemName,$Data) ;
	}



	/**
	 * 取得数据项数据
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @param	$sItemName		string	数据项名称
	 * @return	mixed
	 */
	public function GetItem(  $sKeyPath,  $sItemName ) 
	{
		$aKey = $this->GetKey($sKeyPath) ;
		if(!$aKey)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法找到指定的键：%s', 'JCAT', null, $sKeyPath
			)) ;
		}
		return $aKey->GetItem($sItemName) ;
	}



	/**
	 * 删除数据项
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @param	$sItemName		string	数据项名称
	 * @return	bool
	 */
	public function DeleteItem(  $sKeyPath,  $sItemName ) 
	{
		return $this->GetKey($sKeyPath)->DeleteItem($sItemName) ;
	}



	/**
	 * 创建键
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	bool
	 */
	public function CreateKey(  $sKeyPath ) 
	{
		$sNewKeyName = basename($sKeyPath) ;
		$sParentKeyPath = dirname($sKeyPath) ;
		if($sParentKeyPath==='.')
		{
			$sParentKeyPath = '/' ;
		}

		$aParentKey = $this->GetKey($sParentKeyPath) ;
		if(!$aParentKey)
		{
			if( $sParentKeyPath!='/' and !$this->CreateKey($sParentKeyPath) )
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'无法递归创建上级键：%s ', 'JCAT', null, $sParentKeyPath
				)) ;
			}
			
			$aParentKey = $this->GetKey($sParentKeyPath) ;
			JCAT_ASSERT::ASSERT_INSTANCE($aParentKey);
		}
		
		return $aParentKey->CreateKey($sNewKeyName) ;
	}



	/**
	 * 取得子键对象
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	JCAT_IPreferenceKey
	 */
	public function GetKey( $sKeyPath ) 
	{
		$sKeyPath = trim($sKeyPath) ;
		$sKeyPath = str_replace('\\','/',$sKeyPath) ;
		
		if($sKeyPath=='/')
		{
			return $this->aRootKey ;
		}
		else
		{
			$arrPath = explode('/',$sKeyPath) ;
			return $this->aRootKey->GetKeyByPath($arrPath) ;
		}
		
	}


	/**
	 * 删除子键
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	bool
	 */
	public function DeleteKey(  $sKeyPath ) 
	{
		$sKeyName = basename($sKeyPath) ;
		$sParentKeyPath = dirname($sKeyPath) ;
		if($sParentKeyPath==='.')
		{
			$sParentKeyPath = '/' ;
		}
		
		return $this->GetKey($sParentKeyPath)->DeleteKey($sKeyName) ;
	}


	/**
	 * 返回一个子键是否存在
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	bool
	 */
	public function HasKey(  $sKeyPath ) 
	{
		$aRootKey = $this->aRootKey ;
		$sKeyFSPath = $aRootKey->GetFSPath() . $sKeyPath ;
		
		if( !is_dir($sKeyFSPath) )
		{
			return false ;
		}
		
		return is_readable($sKeyFSPath.'/'.JCAT_FSPreferenceKey::ITEM_DATA_FILENAME) ;
	}
	
	/**
	 * 返回一个数据项是否存在
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @param	$sItemName		string	数据项名称
	 * @return	bool
	 */
	public function HasItem(  $sKeyPath, $sItemName )
	{
		try
		{
			$ItemValue = $this->GetItem($sKeyPath,$sItemName) ;
		}
		
		catch (Exception $e)
		{
			return false ;
		}
		
		return ($ItemValue!==null) ;
	}
	

	/**
	 * 创建一个子配置独享
	 *
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	JCAT_FSPreference
	 */
	public function CreateSubPreference($sKeyPath)
	{
		$aKey = $this->GetKey($sKeyPath) ;
		$sPath = $aKey->GetFSPath() ;
		
		return new JCAT_FSPreference($sPath) ;		
	}

	/**
	 * 创建子键迭代器
	 *
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	JCAT_IIterator
	 */
	public function CreateChildKeyIterator($sKeyPath)
	{
		$aKey = $this->GetKey($sKeyPath) ;
		return $aKey->CreateChildKeyIterator() ;
	}

	/**
	 * 创建数据项迭代器
	 *
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	JCAT_IIterator
	 */
	public function CreateItemIterator($sKeyPath)
	{
		$aKey = $this->GetKey($sKeyPath) ;
		return $aKey->CreateItemIterator() ;	
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		JCAT_FSPreferenceKey
	 */
	private $aRootKey ;


}
?>