<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_PreferenceModel.php 1913 2009-06-21 15:52:26Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * 用文件系统实现的 配置类.
 *
 * @author		alee
 * @access		public
 */
class JCAT_PreferenceModel extends JCAT_Model
{

	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$aPreference	JCAT_IPreference
	 * @return	void
	 */
	public function JCAT_PreferenceModel(JCAT_IPreference $aPreference) 
	{
		$this->JCAT_Model() ;
		$this->aPreference = $aPreference ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IPreference
	 */
	public function GetPreference()
	{
		return $this->aPreference ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function SetItem($sKey,$sItem,$sMapToData)
	{
		$this->arrItemDataMappings[$sMapToData] = array($sKey,$sItem) ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDataName				string		What's this Parameter ?
	 * @param	$Value					mixed		What's this Parameter ?
	 * @param	$bSetChanged=true		bool		What's this Parameter ?
	 * @return	old_var
	 */
	public function Set( $sDataName, $Value, $bSetChanged=true )
	{
		JCAT_ASSERT::ASSERT_STRING($sDataName) ;
		
		if( !$this->IsDataExists($sDataName) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'正在存储一个不存在的模型数据：“%s”。'
				, 'JCAT', null, $sDataName
			)) ;
		}

		$old_var = $this->Get($sDataName) ;
		$Value = ($this->IsAutoDecodeHtml() and is_string($Value))? htmlspecialchars($Value,ENT_NOQUOTES): $Value ;
		
		// 保存到 preference
		list($sKey,$sItem) = $this->arrItemDataMappings[$sDataName] ;
		if( !$this->aPreference->HasKey($sKey) )
		{
			$this->aPreference->CreateKey($sKey) ;
		}
		$this->aPreference->SetItem($sKey,$sItem,$Value) ;
		
		if( $bSetChanged and $Value!==$old_var )
		{
			$this->SetChanged() ;
		}
			
		return $old_var ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDataName	string	What's this Parameter ?
	 * @return	mixed, null
	 */
	public function Get( $sDataName )
	{
		JCAT_ASSERT::ASSERT_STRING($sDataName) ;
		
		if(!$this->IsDataExists($sDataName))
		{
			return null ;
		}
		
		list($sKey,$sItem) = $this->arrItemDataMappings[$sDataName] ;
		if( !$this->aPreference->HasKey($sKey) )
		{
			$this->aPreference->CreateKey($sKey) ;
		}
		return $this->aPreference->GetItem($sKey,$sItem) ;
	}
	

	/**
	 * 检查模型数据 $sDataName 是否存在 
	 * 
	 * @access	public
	 * @param	$sDataName		string
	 * @return	bool
	 */
	public function IsDataExists($sDataName)
	{
		$arrItemDataMappingss =& $this->arrItemDataMappings ;		// array_key_exists() 无法直接访问私有属性 $this->arrItemDataMappings 
		return array_key_exists($sDataName,$arrItemDataMappingss) ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		JCAT_IPreference
	 */
	private $aPreference ;


	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrItemDataMappings = array() ;
}
?>