<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IPreference.php 1642 2009-04-09 10:03:39Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

/**
 * 配置
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IPreference
{


	/**
	 * 设置一个数据项
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @param	$sItemName		string	数据项名称
	 * @param	$Data			mixed	数据
	 * @return	old_value
	 */
	public function SetItem(  $sKeyPath,  $sItemName,  $Data )  ;



	/**
	 * 取得数据项数据
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @param	$sItemName		string	数据项名称
	 * @return	mixed
	 */
	public function GetItem(  $sKeyPath,  $sItemName )  ;



	/**
	 * 删除数据项
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @param	$sItemName		string	数据项名称
	 * @return	bool
	 */
	public function DeleteItem(  $sKeyPath,  $sItemName )  ;



	/**
	 * 创建键
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	JCAT_IPreferenceKey
	 */
	public function CreateKey(  $sKeyPath )  ;



	/**
	 * 取得子键对象
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	JCAT_IPreferenceKey
	 */
	public function GetKey(  $sKeyPath )  ;



	/**
	 * 删除子键
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	bool
	 */
	public function DeleteKey(  $sKeyPath )  ;

	
	/**
	 * 返回一个子键是否存在
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	bool
	 */
	public function HasKey(  $sKeyPath )  ;
	
	/**
	 * 返回一个数据项是否存在
	 * 
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @param	$sItemName		string	数据项名称
	 * @return	bool
	 */
	public function HasItem(  $sKeyPath, $sItemName )  ;


	/**
	 * 创建一个子配置独享
	 *
	 * @access	public
	 * @param	$sKeyPath		string	键路径
	 * @return	JCAT_IPreference
	 */
	public function CreateSubPreference($sKeyPath) ;


	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>