<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IPreferenceKey.php 1890 2009-06-07 12:59:38Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * 配置键
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IPreferenceKey
{

	/**
	 * 返回键名称
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetName() ;

	/**
	 * 设置一个数据项
	 * 
	 * @access	public
	 * @param	$sItemName		string	数据项名称
	 * @param	$Data			mixed	数据
	 * @return	old_value
	 */
	public function SetItem(  $sItemName, $Data )  ;


	/**
	 * 删除键
	 *
	 * @access	public
	 * @return	bool
	 */
	public function Delete() ;
	

	/**
	 * 取得数据项数据
	 * 
	 * @access	public
	 * @param	$sItemName		string	数据项名称
	 * @return	mixed
	 */
	public function & GetItem(  $sItemName )  ;



	/**
	 * 删除数据项
	 * 
	 * @access	public
	 * @param	$sItemName		string	数据项名称
	 * @return	bool
	 */
	public function DeleteItem(  $sItemName )  ;



	/**
	 * 创建子键
	 * 
	 * @access	public
	 * @param	$sKeyName		string	子键键名
	 * @return	bool
	 */
	public function CreateKey(  $sKeyName )  ;



	/**
	 * 取得子键对象
	 * 
	 * @access	public
	 * @param	$sKeyName		string	子键键名
	 * @return	JCAT_IPreferenceKey
	 */
	public function GetKey(  $sKeyName )  ;



	/**
	 * 删除子键
	 * 
	 * @access	public
	 * @param	$sKeyName		string	子键键名
	 * @return	bool
	 */
	public function DeleteKey(  $sKeyName )  ;


	/**
	 * 创建子键迭代器
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateChildKeyIterator() ;
	

	/**
	 * 创建数据项迭代器
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateItemIterator() ;
	
	
	/**
	 * 保存键
	 *
	 * @access	public
	 * @return	bool
	 */
	public function Save() ;

	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>