<?php


/**
 * Session 的 数据库实现方案
 *
 */
class JCAT_DBSession implements JCAT_ISession
{
	/**
	 * 创建一个会话对象
	 * 
	 * @access 	public 
	 * @param 	$nExpireSec=900		int		过期时间 
	 * @param 	$sSessionKey=null	string 
	 * @return 	JCAT_ISession 
	 * @see 	JCAT_ISession::StartSession()
	 */
	public static function StartSession ($nExpireSec = 900, $sSessionKey = null)
	{
	}
	
	/**
	 * 构造函数，只能通过 StartSession() 方法调用
	 * 
	 * @access 	private 
	 * @param 	$sTableName					string	用于保存会话的数据表表名
	 * @param 	$sSessionKeyColumnName		string	会话键的字段名
	 * @param 	$sSessionStoreColumnName	string	存储会话数据的字段名
	 * @param 	$sExpireTimeColumnName		string	记录会话终止时间的字段名
	 * @return 	void 
	 */
	final protected function __construct($sTableName,$sSessionKeyColumnName,$sSessionStoreColumnName,$sExpireTimeColumnName)
	{
		$this->sTableName = $sTableName ;
		
		$this->sSessionKeyColumnName = $sSessionKeyColumnName ;
		
		$this->sSessionStoreColumnName = $sSessionStoreColumnName ;
		
		$this->sExpireTimeColumnName = $sExpireTimeColumnName ;
	}
	
	/**
	 * 取回 Session 键名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetSessionKey()
	{
	}
	
	/**
	 * 
	 * @access 	public 
	 * @param 	$sVarName	string	变量名称 
	 * @param 	$Value		mxied	变量值 
	 * @return 	old_value 
	 * @see JCAT_ISession::SetVariable()
	 */
	public function SetVariable ($sVarName, $Value)
	{
	}

	/**
	 * 
	 * @access 	public 
	 * @param 	$sVarName	string	变量名称 
	 * @return 	mxied 
	 * @see JCAT_ISession::GetVariable()
	 */
	public function GetVariable ($sVarName)
	{
	}
	
	/**
	 * 
	 * @access 	public 
	 * @param 	$sVarName	string	变量名称 
	 * @return 	variable ref 
	 * @see JCAT_ISession::GetVariableRef()
	 */
	public function & GetVariableRef ($sVarName)
	{
	}
	
	/**
	 * 
	 * @access 	public 
	 * @param 	$sVarName	string	变量名称 
	 * @return 	bool 
	 * @see JCAT_ISession::DeleteVariable()
	 */
	public function DeleteVariable ($sVarName)
	{
	}
	
	/**
	 * 
	 * @access public 
	 * @return void 
	 * @see JCAT_ISession::ClearVariable()
	 */
	public function ClearVariable ()
	{
	}
	
	
	/**
	 * 终止会话
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function TerminateSession()
	{
	}


	// 属性  //////////////////////////////////////////
	
	private $sTableName ;
	
	private $sSessionKeyColumnName ;
	
	private $sSessionStoreColumnName ;
	
	private $sExpireTimeColumnName ;

}
?>
