<?php


/**
 * 对 PHP 原生 session 函数库的封装
 *
 */
class JCAT_OriginalSession implements JCAT_ISession
{
	/**
	 * 创建一个会话对象
	 * 
	 * @access 	public 
	 * @param 	$nExpireSec=900		int		过期时间 
	 * @param 	$sSessionKey=null	string 
	 * @return 	JCAT_ISession 
	 * @see 	JCAT_ISession::StartSession()
	 */
	public static function StartSession ($nExpireSec = 900, $sSessionId = null)
	{
		if( !isset($_SESSION) )
		{
			// 过期时间
			session_cache_expire($nExpireSec) ;
			
			// 设置会话ID
			if($sSessionId!==null)
			{
				session_id($sSessionId) ;
			}
			
			if( !session_start() )
			{
				return null ;
			}
		}
		
		if( !self::$aGlobalInstance )
		{
			self::$aGlobalInstance = new JCAT_OriginalSession() ;
		}

		return self::$aGlobalInstance ;
	}
	
	/**
	 * 只能通过 JCAT_Session::StartSession() 创建对象
	 * 
	 * @access private 
	 * @return void 
	 */
	private function JCAT_OriginalSession()
	{}
	
	/**
	 * 取回 Session 键名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetSessionId()
	{
		return session_id() ;
	}
	
	/**
	 * 
	 * @access 	public 
	 * @param 	$sVarName	string	变量名称 
	 * @param 	$Value		mxied	变量值 
	 * @return 	old_value 
	 * @see JCAT_ISession::SetVariable()
	 */
	public function SetVariable ($sVarName, $Value)
	{
		$old_value = isset($_SESSION[ $sVarName ])? $_SESSION[ $sVarName ]: null ;
		$_SESSION[ $sVarName ] = $Value ;
		return $old_value ;
	}

	/**
	 * 
	 * @access 	public 
	 * @param 	$sVarName	string	变量名称 
	 * @return 	mxied 
	 * @see JCAT_ISession::GetVariable()
	 */
	public function GetVariable ($sVarName)
	{
		return isset($_SESSION[ $sVarName ])? $_SESSION[ $sVarName ]: null ;
	}
	
	/**
	 * 
	 * @access 	public 
	 * @param 	$sVarName	string	变量名称 
	 * @return 	variable ref 
	 * @see JCAT_ISession::GetVariableRef()
	 */
	public function & GetVariableRef ($sVarName)
	{
		return isset($_SESSION[ $sVarName ])? $_SESSION[ $sVarName ]: null ;
	}
	
	/**
	 * 
	 * @access 	public 
	 * @param 	$sVarName	string	变量名称 
	 * @return 	bool 
	 * @see JCAT_ISession::DeleteVariable()
	 */
	public function DeleteVariable ($sVarName)
	{
		return session_unregister($sVarName) ;
	}
	
	/**
	 * 
	 * @access public 
	 * @return void 
	 * @see JCAT_ISession::ClearVariable()
	 */
	public function ClearVariable ()
	{
		$_SESSION = array();
	}
	
	
	/**
	 * 终止会话
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function TerminateSession()
	{
		// 清除 所有 Session 变量
		$this->ClearVariable() ;

		// 清除 Cookie
		if (isset($_COOKIE[session_name()]))
		{
			setcookie(session_name(), '', time()-42000, '/');
		}
		
		// 
		session_destroy();
	}

	// 属性 ////////////////////////////////
	
	/**
	 * 单件实例
	 * 
	 * @access	private
	 * @var		JCAT_Session
	 * @static 
	 */
	static private $aGlobalInstance ;
}
?>
