<?php


/**
 * 对 PHP 原生Session 函数库的封装
 *
 */
class JCAT_Session
{
	/**
	 * set a default session object
	 *
	 * @access	public
	 * @param	$aGlobalInstance		JCAT_ISession
	 * @static 
	 * @return	JCAT_ISession
	 */
	static public function SetGlobalInstance(JCAT_ISession $aGlobalInstance)
	{
		self::$aGlobalInstance = $aGlobalInstance ;
	}
	
	/**
	 * set default session object
	 *
	 * @access	public
	 * @static 
	 * @return	JCAT_ISession
	 */
	static public function GetGlobalInstance()
	{
		// create default
		if( !self::$aGlobalInstance )
		{
			self::$aGlobalInstance = JCAT_OriginalSession::StartSession() ;
		}
		
		return self::$aGlobalInstance ;
	}
	
	// 属性 ////////////////////////////////
	
	/**
	 * 单件实例
	 * 
	 * @access	private
	 * @var		JCAT_Session
	 * @static 
	 */
	static private $aGlobalInstance ;
}
?>
