<?php

/**
 * 会话接口
 */
interface JCAT_ISession
{
	
	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param 	$nExpireSec=900		int		过期时间
	 * @param 	$sSessionKey=900	string
	 * @return	JCAT_ISession
	 */
	static public function StartSession( $nExpireSec=900, $sSessionKey=null ) ;
	
	
	/**
	 * 取回 Session 键名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetSessionId() ;
	
	/**
	 * 设置会话变量
	 * 
	 * @access	public
	 * @param	$sVarName	string	变量名称
	 * @param	$Value		mxied	变量值
	 * @return	old_value
	 */
	public function SetVariable($sVarName,$Value) ;
	
	/**
	 * 取回会话变量值
	 * 
	 * @access	public
	 * @param	$sVarName	string	变量名称
	 * @return	mxied
	 */
	public function GetVariable($sVarName) ;
	
	/**
	 * 取回会话变量的引用
	 * 
	 * @access	public
	 * @param	$sVarName	string	变量名称
	 * @return	variable ref
	 */
	public function & GetVariableRef($sVarName) ;
	
	
	/**
	 * 删除会话变量
	 * 
	 * @access	public
	 * @param	$sVarName	string	变量名称
	 * @return	bool
	 */
	public function DeleteVariable($sVarName) ;
	
	
	/**
	 * 清除所有的会话变量
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function ClearVariable() ;
	
	
	/**
	 * 终止会话
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function TerminateSession() ;

}
?>
