<?
/*-- Project Introduce --*/


/**
 * JCAT_Preg 是对 preg_match_all() 的封装，
 * 用途在于简化对 preg_match_all() 输出结果数组的访问。
 * JCAT_Preg 总是使用 PREG_OFFSET_CAPTURE|PREG_PATTERN_ORDER 执行 preg_match_all()
 * 
 */
class JCAT_Preg
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sRegExp
	 * @return	void
	 */
	public function JCAT_Preg($sRegExp)
	{
		$this->sRegExp = $sRegExp ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function Match($sSource)
	{
		return preg_match_all($this->sRegExp,$sSource,$this->arrResult,PREG_PATTERN_ORDER|PREG_OFFSET_CAPTURE) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetRegExp()
	{
		return $this->sRegExp ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function SetRegExp($sRegExp)
	{
		$this->sRegExp = $sRegExp ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetResult()
	{
		return $this->arrResult ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetFound($nGrp,$nResultIdx=0)
	{
		return isset($this->arrResult[$nGrp][$nResultIdx][0])?
				$this->arrResult[$nGrp][$nResultIdx][0]: null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetResultCount()
	{
		return count($this->arrResult[0]) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_PregResultIterator
	 */
	public function CreateResultIter()
	{
		if(empty($this->arrResult))
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'尚无结果，需要先调用 Match() 方法。', 'JCAT', null
			)) ;
		}
		
		return new JCAT_PregResultIterator($this->arrResult) ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sRegExp ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrResult = array() ;
	
}


class JCAT_PregResultIterator extends JCAT_ArrayIterator 
{
	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$arrResult	array	目标数组
	 * @return	void
	 */
	public function JCAT_PregResultIterator( array &$arrResult )
	{
		//
		$this->arrResult = $arrResult ;
		$this->JCAT_ArrayIterator($arrResult[0]) ;
	}
	
	/**
	 * Description
	 *
	 * @access	Private
	 * @param	$sOperation
	 * @return	void
	 */
	Private function Access($sOperation,$nGrp=0,$bPos=false)
	{
		$nElement = $bPos? 1: 0 ;
		
		parent::$sOperation() ;
		$nIdx = $this->CurrentKey() ;
		
		return ($nIdx===null)?
					null: $this->arrResult[$nGrp][$nIdx][$nElement] ;
	}

	/**
	 * 返回当前内容
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function First($nGrp=0)
	{
		return $this->Access(__FUNCTION__,$nGrp,false) ;
	}


	/**
	 * 迭代之下一个
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Next($nGrp=0)
	{
		return $this->Access(__FUNCTION__,$nGrp,false) ;
	}

	/**
	 * 返回当前内容
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Current($nGrp=0)
	{
		return $this->Access(__FUNCTION__,$nGrp,false) ;
	}


	/**
	 * 迭代 退至前一个，如果超过第一个，迭代终止
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Previous($nGrp=0)
	{ 
		return $this->Access(__FUNCTION__,$nGrp,false) ;
	}

	/**
	 * 返回最后一项，迭代终止
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Last($nGrp=0)
	{
		return $this->Access(__FUNCTION__,$nGrp,false) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function CurrentPos($nGrp=0)
	{
		return $this->Access('Current',$nGrp,true) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetResultCount()
	{
		return $this->arrResult[0] ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $arrResult ;
}

?>