<?php
// Call JCAT_BacktraceTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_BacktraceTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/Backtrace/class.JCAT_Backtrace.php';

class b
{
	static function bbb()
	{
		$b = new b() ;
		$Ret = $b->bb() ;
		$GLOBALS['b_bbCalledLine'] = __LINE__-1 ;
		
		return $Ret ;
	}
	
	function bb()
	{
		return JCAT_Backtrace::GetStack() ;
	}
	
	
	static function ddd()
	{
		$b = new b() ;
		$Ret = $b->dd() ;
		$GLOBALS['b_ddCalledLine'] = __LINE__-1 ;
		
		return $Ret ;
	}
	function dd()
	{
		return JCAT_Backtrace::GetCaller() ;
	}
}


/**
 * Test class for JCAT_Backtrace.
 * Generated by PHPUnit on 2007-12-19 at 17:42:58.
 */
class JCAT_BacktraceTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_BacktraceTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testGetStack().
     */
    public function testGetStack() {
        
		$aStack = b::bbb() ;
		
		$this->assertEquals( $aStack->GetClass(), 'b' ) ;
		$this->assertEquals( $aStack->GetFunction(), 'bb' ) ;
		$this->assertEquals( $aStack->GetFile(), __FILE__ ) ;
    }

    /**
     * @todo Implement testGetCaller().
     */
    public function testGetCaller() {
		$aCaller = b::ddd() ;
		$nB_DDDCallLine = __LINE__ - 1 ;
		
		$this->assertEquals( $aCaller->GetClass(), 'b' ) ;
		$this->assertEquals( $aCaller->GetFunction(), 'ddd' ) ;
		$this->assertEquals( $aCaller->GetFile(), __FILE__ ) ;
		$this->assertEquals( $aCaller->GetLineForCall(), $GLOBALS['b_ddCalledLine'] ) ;
		
		$aCallerSCaller = $aCaller->GetCaller() ;
		$this->assertEquals( $aCallerSCaller->GetClass(), __CLASS__ ) ;
		$this->assertEquals( $aCallerSCaller->GetFunction(), __FUNCTION__ ) ;
		$this->assertEquals( $aCallerSCaller->GetFile(), __FILE__ ) ;
		$this->assertEquals( $aCallerSCaller->GetLineForCall(), $nB_DDDCallLine ) ;
    }
}

// Call JCAT_BacktraceTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_BacktraceTest::main')
	JCAT_BacktraceTest::main();
?>
