<?php
// Call _JCAT_CallerTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', '_JCAT_CallerTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/Backtrace/class._JCAT_Caller.php';

class b
{
	static function bbb()
	{
		$b = new b() ;
		return $b->bb() ;
	}
	
	function bb()
	{
		return JCAT_Backtrace::GetBacktrace() ;
	}
}




/**
 * Test class for _JCAT_Caller.
 * Generated by PHPUnit on 2007-12-19 at 16:18:58.
 */
class _JCAT_CallerTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('_JCAT_CallerTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testGetCaller().  调用者 的 调用者
     */
    public function testGetCaller() {

		$aCaller = new _JCAT_Caller( b::bbb() ) ;
		$nLine = __LINE__ ;
		$aCallerSCaller = $aCaller->GetCaller() ;
		
		$this->assertEquals( $aCaller->GetClass(),'b' ) ;						// 调用者 所属类
		$this->assertEquals( $aCaller->GetFunction(),'bbb' ) ;					// 调用者 所属方法
		
		$this->assertEquals( $aCallerSCaller->GetClass(),__CLASS__ ) ;			// 调用者的 调用者 所属类
		$this->assertEquals( $aCallerSCaller->GetFunction(),__FUNCTION__ ) ;	// 调用者的 调用者 所属方法
		$this->assertEquals( $aCallerSCaller->GetFile(),__FILE__ ) ;			// 调用者的 调用者 所在文件
		$this->assertEquals( $aCallerSCaller->GetLineForCall(),$nLine-1 ) ;		// 调用者的 调用者 所在行数
    }

    /**
     * @todo Implement testGetCallPoint().
     */
    public function testGetCallPoint() {
	
		// Caller 此测试用例 
		$b = new b() ;
		$aCaller = new _JCAT_Caller($b->bb()) ;
		$nLine = __LINE__ ;
		
		$aCallPoint = $aCaller->GetCallPoint() ;
		
		$this->assertEquals( $aCallPoint->GetClass(),__CLASS__ ) ;				// 调用执行点 所属类
		$this->assertEquals( $aCallPoint->GetFunction(),__FUNCTION__ ) ;		// 调用执行点 所属方法
		$this->assertEquals( $aCallPoint->GetFile(),__FILE__ ) ;				// 调用执行点 所在文件
		$this->assertEquals( $aCallPoint->GetLine(),$nLine-1 ) ;				// 调用执行点 所在行数
    }

    /**
     * @todo Implement testGetCalledStack().
     */
    public function testGetCalledStack() {
	
		$b = new b() ;
		$aCaller = new _JCAT_Caller($b->bb()) ;
		$aCalledStack = $aCaller->GetCalledStack() ;
		
		$this->assertEquals( $aCalledStack->GetClass(),'b' ) ;					// 被调用栈 类
		$this->assertEquals( $aCalledStack->GetFunction(),'bb' ) ;				// 被调用栈方法
		$this->assertEquals( $aCalledStack->GetFile(),__FILE__ ) ;				// 被调用栈方法
    }

    /**
     * @todo Implement testGetClass().
     */
    public function testGetClassFunctionFileLine() {
       
		// Caller 此测试用例 
		$b = new b() ;
		$aCaller = new _JCAT_Caller($b->bb()) ;
		$nLine = __LINE__ ;
		
		$this->assertEquals( $aCaller->GetClass(),__CLASS__ ) ;					// 调用者 类
		$this->assertEquals( $aCaller->GetFunction(),__FUNCTION__ ) ;			// 调用者方法
		$this->assertEquals( $aCaller->GetFile(),__FILE__ ) ;					// 调用者所在文件
		$this->assertEquals( $aCaller->GetLineForCall(),$nLine-1 ) ;			// 调用执行点 行数
    }

    /**
     * @todo Implement testGetCalledClass().
     */
    public function testGetCalledClassFunctionFile() {
        
		$b = new b() ;
		$aCaller = new _JCAT_Caller($b->bb()) ;
		
		$this->assertEquals( $aCaller->GetCalledClass(),'b' ) ;					// 被调用栈 类
		$this->assertEquals( $aCaller->GetCalledFunction(),'bb' ) ;				// 被调用栈方法
		$this->assertEquals( $aCaller->GetCalledFile(),__FILE__ ) ;				// 被调用栈方法
    }
}

// Call _JCAT_CallerTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == '_JCAT_CallerTest::main')
	_JCAT_CallerTest::main();
?>
