<?php
// Call _JCAT_ExecutingPointTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', '_JCAT_ExecutingPointTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/Backtrace/class._JCAT_ExecutingPoint.php';

$GLOBALS['arrGlobalBacktrace'] = JCAT_Backtrace::GetBacktrace() ;
function aaa()
{
	return JCAT_Backtrace::GetBacktrace() ;
}
$GLOBALS['arrGlobaltionBacktrace'] = aaa() ;


class b
{
	static function bbb()
	{
		return JCAT_Backtrace::GetBacktrace() ;
	}
	
	function bbbbbb()
	{
		return JCAT_Backtrace::GetBacktrace() ;
	}
}


/**
 * Test class for _JCAT_ExecutingPoint.
 * Generated by PHPUnit on 2007-12-19 at 15:45:08.
 */
class _JCAT_ExecutingPointTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('_JCAT_ExecutingPointTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testGlobalStack().  全局代码 栈
     */
    public function testGlobalStack() {
       
		$aPoint = new _JCAT_ExecutingPoint($GLOBALS['arrGlobalBacktrace']) ;

		$this->assertEquals( md5_file($aPoint->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aPoint->GetClass(), '' ) ;							// 没有所在类
		$this->assertEquals( $aPoint->GetFunction(), 'include_once' ) ;				// 通过 include_once 载入
		$this->assertEquals( $aPoint->GetLine(), 11 ) ;								// 执行点 所在 行
		$this->assertEquals( $aPoint->GetFlag(), _JCAT_ExecutingStack::SCOPE_GLOBAL ) ;

		$this->assertTrue( $aPoint->IsGlabalCode() ) ;
		$this->assertFalse( $aPoint->IsGlabalFunction() ) ;
		$this->assertFalse( $aPoint->IsStaticMethod() ) ;
		$this->assertFalse( $aPoint->IsInstanceMethod() ) ;
    }
	
	
    /**
     * @todo Implement testGlobalStack().  全局函数 栈
     */
    public function testGlobaltionStack() {
       
		$aPoint = new _JCAT_ExecutingPoint($GLOBALS['arrGlobaltionBacktrace']) ;

		$this->assertEquals( md5_file($aPoint->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aPoint->GetClass(), '' ) ;							// 没有所在类
		$this->assertEquals( $aPoint->GetFunction(), 'aaa' ) ;						// 函数名
		$this->assertEquals( $aPoint->GetLine(), 14 ) ;								// 执行点 所在 行
		$this->assertEquals( $aPoint->GetFlag(), 
				_JCAT_ExecutingStack::SCOPE_LOCAL|_JCAT_ExecutingStack::TYPE_PROCESS ) ;
				
		$this->assertFalse( $aPoint->IsGlabalCode() ) ;
		$this->assertTrue( $aPoint->IsGlabalFunction() ) ;
		$this->assertFalse( $aPoint->IsStaticMethod() ) ;
		$this->assertFalse( $aPoint->IsInstanceMethod() ) ;
				
				
		$aPoint = new _JCAT_ExecutingPoint(aaa()) ;
		
		$this->assertEquals( md5_file($aPoint->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aPoint->GetClass(), '' ) ;							// 没有所在类
		$this->assertEquals( $aPoint->GetFunction(), 'aaa' ) ;						// 函数名
		$this->assertEquals( $aPoint->GetLine(), 14 ) ;								// 执行点 所在 行
		$this->assertEquals( $aPoint->GetFlag(), 
				_JCAT_ExecutingStack::SCOPE_LOCAL|_JCAT_ExecutingStack::TYPE_PROCESS ) ;
				
		$this->assertFalse( $aPoint->IsGlabalCode() ) ;
		$this->assertTrue( $aPoint->IsGlabalFunction() ) ;
		$this->assertFalse( $aPoint->IsStaticMethod() ) ;
		$this->assertFalse( $aPoint->IsInstanceMethod() ) ;
    }
	
	
    /**
     * @todo Implement testStaticMethod().  静态方法 栈
     */
    public function testStaticMethod() {
       
		$aPoint = new _JCAT_ExecutingPoint(b::bbb()) ;
		
		$this->assertEquals( md5_file($aPoint->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aPoint->GetClass(), 'b' ) ;							// 所在类
		$this->assertEquals( $aPoint->GetFunction(), 'bbb' ) ;						// 函数名
		$this->assertEquals( $aPoint->GetLine(), 23 ) ;								// 执行点 所在 行
		$this->assertEquals( $aPoint->GetFlag(), 
				_JCAT_ExecutingStack::SCOPE_LOCAL|_JCAT_ExecutingStack::TYPE_CLASS|_JCAT_ExecutingStack::METHOD_CLASS ) ;
				
		$this->assertFalse( $aPoint->IsGlabalCode() ) ;
		$this->assertFalse( $aPoint->IsGlabalFunction() ) ;
		$this->assertTrue( $aPoint->IsStaticMethod() ) ;
		$this->assertFalse( $aPoint->IsInstanceMethod() ) ;
    }
	
	
    /**
     * @todo Implement testInstanceMethod().  实例方法 栈
     */
    public function testInstanceMethod() {
       
		$b = new b() ;
		$aPoint = new _JCAT_ExecutingPoint($b->bbbbbb()) ;
		
		$this->assertEquals( md5_file($aPoint->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aPoint->GetClass(), 'b' ) ;							// 所在类
		$this->assertEquals( $aPoint->GetFunction(), 'bbbbbb' ) ;					// 函数名
		$this->assertEquals( $aPoint->GetLine(), 28 ) ;								// 执行点 所在 行
		$this->assertEquals( $aPoint->GetFlag(), 
				_JCAT_ExecutingStack::SCOPE_LOCAL|_JCAT_ExecutingStack::TYPE_CLASS|_JCAT_ExecutingStack::METHOD_INSTANCE ) ;
				
		$this->assertFalse( $aPoint->IsGlabalCode() ) ;
		$this->assertFalse( $aPoint->IsGlabalFunction() ) ;
		$this->assertFalse( $aPoint->IsStaticMethod() ) ;
		$this->assertTrue( $aPoint->IsInstanceMethod() ) ;
    }
}

// Call _JCAT_ExecutingPointTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == '_JCAT_ExecutingPointTest::main')
	_JCAT_ExecutingPointTest::main();
?>
