<?php
// Call _JCAT_ExecutingStackTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', '_JCAT_ExecutingStackTest::main');


require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/Backtrace/class._JCAT_ExecutingStack.php';

$GLOBALS['arrGlobalBacktrace'] = JCAT_Backtrace::GetBacktrace() ;
function aaa()
{
	return JCAT_Backtrace::GetBacktrace() ;
}
$GLOBALS['arrGlobaltionBacktrace'] = aaa() ;


class b
{
	static function bbb()
	{
		return JCAT_Backtrace::GetBacktrace() ;
	}
	
	function bbbbbb()
	{
		return JCAT_Backtrace::GetBacktrace() ;
	}
}


require_once 'PHPUnit/Framework.php';


/**
 * Test class for _JCAT_ExecutingStack.
 * Generated by PHPUnit on 2007-12-19 at 11:49:18.
 */
class _JCAT_ExecutingStackTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('_JCAT_ExecutingStackTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testGlobalStack().  全局代码 栈
     */
    public function testGlobalStack() {
       
		$aStack = new _JCAT_ExecutingStack($GLOBALS['arrGlobalBacktrace']) ;

		$this->assertEquals( md5_file($aStack->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aStack->GetClass(), '' ) ;							// 没有所在类
		$this->assertEquals( $aStack->GetFunction(), 'include_once' ) ;				// 通过 include_once 载入
		$this->assertEquals( $aStack->GetFlag(), _JCAT_ExecutingStack::SCOPE_GLOBAL ) ;

		$this->assertTrue( $aStack->IsGlabalCode() ) ;
		$this->assertFalse( $aStack->IsGlabalFunction() ) ;
		$this->assertFalse( $aStack->IsStaticMethod() ) ;
		$this->assertFalse( $aStack->IsInstanceMethod() ) ;
    }
	
	
    /**
     * @todo Implement testGlobalStack().  全局函数 栈
     */
    public function testGlobaltionStack() {
       
		$aStack = new _JCAT_ExecutingStack($GLOBALS['arrGlobaltionBacktrace']) ;

		$this->assertEquals( md5_file($aStack->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aStack->GetClass(), '' ) ;							// 没有所在类
		$this->assertEquals( $aStack->GetFunction(), 'aaa' ) ;						// 函数名
		$this->assertEquals( $aStack->GetFlag(), 
				_JCAT_ExecutingStack::SCOPE_LOCAL|_JCAT_ExecutingStack::TYPE_PROCESS ) ;
				
		$this->assertFalse( $aStack->IsGlabalCode() ) ;
		$this->assertTrue( $aStack->IsGlabalFunction() ) ;
		$this->assertFalse( $aStack->IsStaticMethod() ) ;
		$this->assertFalse( $aStack->IsInstanceMethod() ) ;
				
				
		$aStack = new _JCAT_ExecutingStack(aaa()) ;
		
		$this->assertEquals( md5_file($aStack->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aStack->GetClass(), '' ) ;							// 没有所在类
		$this->assertEquals( $aStack->GetFunction(), 'aaa' ) ;						// 函数名
		$this->assertEquals( $aStack->GetFlag(), 
				_JCAT_ExecutingStack::SCOPE_LOCAL|_JCAT_ExecutingStack::TYPE_PROCESS ) ;
				
		$this->assertFalse( $aStack->IsGlabalCode() ) ;
		$this->assertTrue( $aStack->IsGlabalFunction() ) ;
		$this->assertFalse( $aStack->IsStaticMethod() ) ;
		$this->assertFalse( $aStack->IsInstanceMethod() ) ;
    }
	
	
    /**
     * @todo Implement testStaticMethod().  静态方法 栈
     */
    public function testStaticMethod() {
       
		$aStack = new _JCAT_ExecutingStack(b::bbb()) ;
		
		$this->assertEquals( md5_file($aStack->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aStack->GetClass(), 'b' ) ;							// 所在类
		$this->assertEquals( $aStack->GetFunction(), 'bbb' ) ;						// 函数名
		$this->assertEquals( $aStack->GetFlag(), 
				_JCAT_ExecutingStack::SCOPE_LOCAL|_JCAT_ExecutingStack::TYPE_CLASS|_JCAT_ExecutingStack::METHOD_CLASS ) ;
				
		$this->assertFalse( $aStack->IsGlabalCode() ) ;
		$this->assertFalse( $aStack->IsGlabalFunction() ) ;
		$this->assertTrue( $aStack->IsStaticMethod() ) ;
		$this->assertFalse( $aStack->IsInstanceMethod() ) ;
    }
	
	
    /**
     * @todo Implement testInstanceMethod().  实例方法 栈
     */
    public function testInstanceMethod() {
       
		$b = new b() ;
		$aStack = new _JCAT_ExecutingStack($b->bbbbbb()) ;
		
		$this->assertEquals( md5_file($aStack->GetFile()), md5_file(__FILE__) ) ;	// 栈所在文件 与 当前文件为 同一个文件
		$this->assertEquals( $aStack->GetClass(), 'b' ) ;							// 所在类
		$this->assertEquals( $aStack->GetFunction(), 'bbbbbb' ) ;					// 函数名
		$this->assertEquals( $aStack->GetFlag(), 
				_JCAT_ExecutingStack::SCOPE_LOCAL|_JCAT_ExecutingStack::TYPE_CLASS|_JCAT_ExecutingStack::METHOD_INSTANCE ) ;
				
		$this->assertFalse( $aStack->IsGlabalCode() ) ;
		$this->assertFalse( $aStack->IsGlabalFunction() ) ;
		$this->assertFalse( $aStack->IsStaticMethod() ) ;
		$this->assertTrue( $aStack->IsInstanceMethod() ) ;
    }
	
}




// Call _JCAT_ExecutingStackTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == '_JCAT_ExecutingStackTest::main')
	_JCAT_ExecutingStackTest::main();
?>
