<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Backtrace.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 调用回路
 *
 * @author		alee
 * @access		public
 */
class JCAT_Backtrace
{


	/**
	 * 为当前的 执行栈（调用 此静态方法 的地方） 返回一个 _JCAT_ExecutingStack 对象
	 * 
	 * @access	public
	 * @static
	 * @return	_JCAT_ExecutingStack
	 */
	static public function GetStack(  ) 
	{
		$arrBacktrace = self::GetBacktrace() ;
		JCAT_ASSERT::ASSERT_( count($arrBacktrace)>=3, '!? what is wrong?' ) ;
		
		array_shift($arrBacktrace) ;
		
		return new _JCAT_ExecutingStack($arrBacktrace) ;
	}



	/**
	 * 为当前函数的 调用者  返回一个 _JCAT_Caller 对象
	 * 
	 * @access	public
	 * @static
	 * @return	_JCAT_Caller
	 */
	static public function GetCaller(  ) 
	{
		$arrBacktrace = self::GetBacktrace() ;
		JCAT_ASSERT::ASSERT_( count($arrBacktrace)>=3, '!? what is wrong?' ) ;
		
		array_shift($arrBacktrace) ;
		
		return new _JCAT_Caller($arrBacktrace) ;
	}

	/**
	 * 返回调用回路
	 * 
	 * @access	public
	 * @static
	 * @return	array
	 */
	static public function GetBacktrace()
	{
		$arrBacktrace = debug_backtrace() ;
		$arrBacktrace['by'] = __CLASS__ ;
		return $arrBacktrace ;
	}

}
/*macro_exception_code:0*/
?>