<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class._JCAT_ExecutingPoint.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 执行栈上的某个调用点
 *
 * @author		alee
 * @access		private
 */
class _JCAT_ExecutingPoint
{
	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$arrBacktrace		array	_JCAT_ExecutingStack::GetBacktrace() 返回的数组
	 * @return	
	 */
	public function _JCAT_ExecutingPoint( array $arrBacktrace ) 
	{
		JCAT_ASSERT::ASSERT_( (isset($arrBacktrace['by']) and $arrBacktrace['by']=='JCAT_Backtrace' ),
				JCAT_Language::SentenceEx("参数 \$arrBacktrace 必须是 static JCAT_Backtrace::GetBacktrace() 返回的数组。",'JCAT',null) ) ;
		
		// 当 使用 ReflectionMethod::invoke() 等非常规调用时，无法跟踪 调用路径
		if( empty($arrBacktrace[0]['line']) )
			$arrBacktrace[0]['line'] = 0 ;

		$this->nExecutingPointLine = $arrBacktrace[0]['line'] ;
		$this->aExecutingStack = new _JCAT_ExecutingStack($arrBacktrace) ;
	}



	/**
	 * 取得执行点所在行
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetLine(  ) 
	{ return $this->nExecutingPointLine ; }

	/**
	 * 取得执行点所在的执行栈
	 * 
	 * @access	public
	 * @return	_JCAT_ExecutingStack
	 */
	public function GetStack() 
	{ return $this->aExecutingStack ; }

	
	/**
	 * self::$aExecutingStack 的 透明围栏
	 * 
	 * @access	public
	 * @return	mixed
	 */	
	function __call($sMethodName,array $arrArgs)
	{
		if( $this->aExecutingStack and method_exists($this->aExecutingStack,$sMethodName) )
			return call_user_func_array( array($this->aExecutingStack,$sMethodName), $arrArgs ) ;
		else
			throw new JCAT_Exception( JCAT_Language::SentenceEx("正在访问不存在的方法：“%s”",'JCAT',null,$sMethodName), JCAT_Exception::MakeExceptionCode(__CLASS__,1) ) ;
	}
	



	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 执行点 行数
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nExecutingPointLine ;
	
	/**
	 * 所在执行栈
	 * 
	 * @access	private
	 * @var		_JCAT_ExecutingStack
	 */
	private $aExecutingStack ;


}
/*macro_exception_code:1*/
?>