<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class._JCAT_ExecutingStack.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * PHP的一个 执行栈，它可以是 全局 或 某个函数
 *
 * @author		alee
 * @access		private
 */
class _JCAT_ExecutingStack
{
	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$arrBacktrace		array	_JCAT_ExecutingStack::GetBacktrace() 返回的数组
	 * @return	
	 */
	public function _JCAT_ExecutingStack( array $arrBacktrace ) 
	{
		JCAT_ASSERT::ASSERT_( (isset($arrBacktrace['by']) and $arrBacktrace['by']=='JCAT_Backtrace'),
				JCAT_Language::SentenceEx("参数 \$arrBacktrace 必须是 static JCAT_Backtrace::GetBacktrace() 返回的数组。",'JCAT',null) ) ;

		$arrStackFileInto = $arrBacktrace[0] ;		// 由回调路径最近的节点 做为 栈 所在文件的信息
		$arrStackInto = isset($arrBacktrace[1])? $arrBacktrace[1]: null ;
													// 由 前一个 节点 做为 栈本身的信息

		// 当 使用 ReflectionMethod::invoke() 等非常规调用时，无法跟踪 调用路径
		if( empty($arrStackFileInto['file']) )
			$arrStackFileInto['file'] = '--Unknow--' ;
		
		$this->sFilePath = $arrStackFileInto['file'] ;
		
		// 局部栈
		if( $arrStackInto )
		{
			$this->sFunctionName = $arrStackInto['function'] ;
			
			// 类
			if( isset($arrStackInto['class']) )
			{
				$this->sClassName = $arrStackInto['class'] ;
				$this->nFlag|= self::SCOPE_LOCAL|self::TYPE_CLASS ;
							
				// 静态方法
				if( $arrStackInto['type']=='::' )
					$this->nFlag|= self::METHOD_CLASS ;
				
				// 实例方法
				else
				{
					$this->aObjectRef = $arrStackInto['object'] ;
					$this->nFlag|= self::METHOD_INSTANCE ;
				}
			}
			
			// 过程
			else
			{
				// 全局代码（）
				if( in_array( strtolower($arrStackInto['function']),array('include','include_once','require','require_once')) )
					$this->nFlag|= self::SCOPE_GLOBAL | self::TYPE_PROCESS ;
				
				// 全局函数
				else
					$this->nFlag|= self::SCOPE_LOCAL | self::TYPE_PROCESS ;
			}
		}
		
		
		// 全局栈 (回调路径中 没有这个 栈的信息)
		else
			$this->nFlag|= self::SCOPE_GLOBAL | self::TYPE_PROCESS ;
		
	}


	/**
	 * 取得所在包的ID。 必须属于一个类，并且此类已经通过 JCAT_Package::RegisterClassID() 注册到一个包
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetPackageID()
	{
		$sClassName = $this->GetClass() ;
		if( empty($sClassName) )
			return 0 ;
		return JCAT_Package::GetPackageIDByClass($sClassName) ;
	}


	/**
	 * 取得所在类
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetClass(  ) 
	{ return $this->sClassName ; }



	/**
	 * 取得所在函数（或方法）
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetFunction(  ) 
	{ return $this->sFunctionName ; }



	/**
	 * 取得所在文件
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetFile(  ) 
	{ return $this->sFilePath ; }



	/**
	 * 返回执行栈的类型
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetFlag(  ) 
	{ return $this->nFlag ; }



	/**
	 * 是否全局代码（不在函数或方法中）
	 * 
	 * @access	public
	 * @return	
	 */
	public function IsGlabalCode(  ) 
	{ return ($this->nFlag & self::SCOPE_LOCAL)? false: true ; }



	/**
	 * 是否全局函数
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsGlabalFunction() 
	{ return ($this->nFlag==(self::SCOPE_LOCAL|self::TYPE_PROCESS)) ; }



	/**
	 * 是否是静态方法
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsStaticMethod() 
	{ return ($this->nFlag==(self::SCOPE_LOCAL|self::TYPE_CLASS|self::METHOD_CLASS)) ; }



	/**
	 * 是否是一个实例方法
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsInstanceMethod() 
	{ return ($this->nFlag==(self::SCOPE_LOCAL|self::TYPE_CLASS|self::METHOD_INSTANCE)) ; }
	
	



	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 类名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sClassName ;

	/**
	 * 函数（或方法）名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sFunctionName ;

	/**
	 * 所属对象引用
	 * 
	 * @access	private
	 * @var		object
	 */
	private $aObjectRef ;

	/**
	 * 所在文件路径
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sFilePath ;

	/**
	 * 记录此执行栈的类型
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nFlag = 0 ;



	/**
	 * 全局代码
	 * 
	 * @access	const
	 * @var		
	 */
	const SCOPE_GLOBAL = 0 ;

	/**
	 * 局部代码
	 * 
	 * @access	const
	 * @var		
	 */
	const SCOPE_LOCAL = 1 ;
	
	/**
	 * 在全局函数（不包括类方法）中，过程化
	 * 
	 * @access	const
	 * @var		
	 */
	const TYPE_PROCESS = 0 ;
	
	/**
	 * 在类中，对象化
	 * 
	 * @access	const
	 * @var		ingt
	 */
	const TYPE_CLASS = 2 ;

	/**
	 * 静态方法
	 * 
	 * @access	const
	 * @var		
	 */
	const METHOD_CLASS = 0 ;
	
	/**
	 * 实例方法
	 * 
	 * @access	const
	 * @var		
	 */
	const METHOD_INSTANCE = 4 ;

}
/*macro_exception_code:0*/
?>