<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class._JCAT_FriendTarget.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 友元目标
 *
 * @author		alee
 * @access		private
 */
class _JCAT_FriendTarget
{

	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$nPackage		int		包 ID
	 * @param	$sClassName		string	类名
	 * @param	$sFunctionName	string	函数/方法 名
	 * @return	void
	 */
	function _JCAT_FriendTarget($nPackageID,$sClassName,$sFunctionName)
	{
		JCAT_ASSERT::ASSERT_INT( $nPackageID, JCAT_Language::SentenceEx('参数 $nPackage 代表包ID 必须为整数','JCAT',null) ) ;
		JCAT_ASSERT::ASSERT_STRING( $sClassName, JCAT_Language::SentenceEx('参数 $sClassName 代表类名 必须为字符串','JCAT',null) ) ;
		JCAT_ASSERT::ASSERT_STRING( $sFunctionName, JCAT_Language::SentenceEx('参数 $sFunctionName 代表函数/方法名 必须为字符串','JCAT',null) ) ;

		$this->nPackageID = $nPackageID ;
		$this->sClass = $sClassName ;
		$this->sFunction = $sFunctionName ;
	}


	/**
	 * 检测 是否有元
	 * 
	 * @access	public
	 * @param	$aCaller	_JCAT_Caller	What's this Parameter ?
	 * @return	bool
	 */
	public function IsFriend( _JCAT_Caller $aCaller ) 
	{
		// 检查包
		if( $this->nPackageID and $aCaller->GetPackageID()!=$this->nPackageID )
			return false ;

		// 检查类
		if( $this->sClass and $aCaller->GetClass()!=$this->sClass )
			return false ;

		// 检查 函数/方法	
		if( $this->sFunction and ($aCaller->GetClass()!=$this->sClass or $aCaller->GetFunction()!=$this->sFunction) )
									// 全局函数  $aCaller->GetClass() 返回空
		{
			return false ;
		}
		
		return true ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 包ID
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nPackageID = 0 ;
	
	/**
	 * 类名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sClass = '' ;

	/**
	 * 函数/方法名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sFunction = '' ;
	
}
/*macro_exception_code:0*/
?>