<?php
// Call JCAT_HDCacheTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_HDCacheTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/Cache/class.JCAT_HDCache.php';


function CreateHDCache()
{ return new JCAT_HDCache( dirname(__FILE__).'/HDCacheTest/' ) ; }

/**
 * Test class for JCAT_HDCache.
 * Generated by PHPUnit on 2007-12-26 at 16:20:57.
 */
class JCAT_HDCacheTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_HDCacheTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testGetCacheDir().
     */
    public function testGetCacheDir() {
        $aCache = CreateHDCache() ;
		$this->assertEquals($aCache->GetCacheDir(),dirname(__FILE__).'/HDCacheTest/') ;
    }

    /**
     * @todo Implement testIsExpired().
     */
    public function testIsExpired() {
        $aCache = CreateHDCache() ;
		$aCache->Set('hii','====') ;
		
		sleep(2) ;
		$this->assertFalse($aCache->IsExpired('hii',3)) ;		// 有效
		$this->assertTrue($aCache->IsExpired('hii',1)) ;		// 过期
		$this->assertFalse($aCache->IsExpired('hii',0)) ;		// 存在即有效
		
		$this->assertTrue($aCache->IsExpired('hii2',3)) ;		// 不存在
		$this->assertTrue($aCache->IsExpired('hii2',1)) ;		// 不存在
		$this->assertTrue($aCache->IsExpired('hii2',0)) ;		// 不存在
		
		$this->assertTrue($aCache->Delete('hii')) ;
		
		$this->assertTrue($aCache->IsExpired('hii',3)) ;		// 已删除
		$this->assertTrue($aCache->IsExpired('hii',1)) ;		// 已删除
		$this->assertTrue($aCache->IsExpired('hii',0)) ;		// 已删除
    }

    /**
     * @todo Implement testSet().
     */
    public function testSetGetDelete() {
        $aCache = CreateHDCache() ;
		$aCache->Set('hii','xx') ;
		
		$this->assertEquals($aCache->Get('hii'),'xx') ;
		$this->assertEquals($aCache->Get('hii2'),null) ;
		
		sleep(2) ;
		$this->assertEquals($aCache->Get('hii'),'xx') ;
		$this->assertEquals($aCache->Get('hii',1),null) ;
		
		$this->assertTrue($aCache->Delete('hii')) ;
		
		//$this->assertEquals($aCache->Get('hii'),null) ;
    }

}

// Call JCAT_HDCacheTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_HDCacheTest::main')
	JCAT_HDCacheTest::main();
?>
